import { ShelfConfig } from '@amp/web-app-components/config/components/shelf';

const defaultShelfConfig = ShelfConfig.get();
const { GRID_MAX_CONTENT, GRID_VALUES, GRID_ROW_GAP } = defaultShelfConfig;

ShelfConfig.set({
    ...defaultShelfConfig,
    GRID_MAX_CONTENT: {
        ...GRID_MAX_CONTENT,
        Brick: GRID_MAX_CONTENT.A,
        FooterLink: GRID_MAX_CONTENT.A,
        InAppPurchaseLockup: GRID_MAX_CONTENT.C,
        LargeBrick: GRID_MAX_CONTENT.A,
        LargeLockup: GRID_MAX_CONTENT.C,
        MediumLockup: GRID_MAX_CONTENT.A,
        PosterLockup: GRID_MAX_CONTENT.A,
        ScreenshotLarge: GRID_MAX_CONTENT.A,
        ScreenshotVision: GRID_MAX_CONTENT.A,
        ScreenshotPhone: GRID_MAX_CONTENT.G,
        ScreenshotPad: GRID_MAX_CONTENT.A,
        SearchLink: GRID_MAX_CONTENT.A,
        SearchResult: GRID_MAX_CONTENT.A,
        SmallLockup: GRID_MAX_CONTENT.A,
        SmallLockupWithOrdinal: {},
        SmallStoryCard: GRID_MAX_CONTENT.A,
        ProductBadge: GRID_MAX_CONTENT.D,
    },
    GRID_VALUES: {
        ...GRID_VALUES,
        Brick: {
            ...GRID_VALUES.A,
            medium: 3,
        },
        InAppPurchaseLockup: {
            xsmall: 3,
            small: 5,
            medium: 6,
            large: 8,
            xlarge: 8,
        },
        LargeBrick: {
            ...GRID_VALUES.C,
            small: 2,
            medium: 2,
            large: 3,
            xlarge: 3,
        },
        LargeLockup: {
            xsmall: 2,
            small: 3,
            medium: 4,
            large: 5,
            xlarge: 6,
        },
        MediumLockup: {
            xsmall: 2,
            small: 2,
            medium: 4,
            large: 5,
            xlarge: 5,
        },
        PosterLockup: {
            ...GRID_VALUES.A,
            xsmall: 1,
            large: 2,
        },
        ProductBadge: {
            ...GRID_VALUES.D,
            small: 5,
            medium: 6,
        },
        SearchLink: {
            xsmall: 1,
            small: 2,
            medium: 3,
            large: 3,
            xlarge: 3,
        },
        SearchResult: {
            xsmall: 1,
            small: 2,
            medium: 3,
            large: 3,
            xlarge: 3,
        },
        FooterLink: {
            xsmall: 1,
            small: 2,
            medium: 3,
            large: 3,
            xlarge: 3,
        },
        SmallLockup: {
            xsmall: 2,
            small: 2,
            medium: 3,
            large: 4,
            xlarge: 4,
        },
        SmallLockupWithOrdinal: {
            xsmall: 2,
            small: 4,
            medium: 5,
            large: 6,
            xlarge: 6,
        },
        SmallStoryCard: {
            xsmall: 2,
            small: 2,
            medium: 2,
            large: 2,
            xlarge: 2,
        },
        ScreenshotLarge: {
            xsmall: 1,
            small: 2,
            medium: 2,
            large: 3,
            xlarge: 3,
        },
        ScreenshotVision: {
            xsmall: 1,
            small: 1,
            medium: 2,
            large: 3,
            xlarge: 3,
        },
        ScreenshotPhone: {
            xsmall: 2,
            small: 3,
            medium: 4,
            large: 5,
            xlarge: 5,
        },
        ScreenshotPad: {
            xsmall: 1,
            small: 3,
            medium: 4,
            large: 4,
            xlarge: 4,
        },
    },
    GRID_ROW_GAP: {
        ...GRID_ROW_GAP,
        Brick: GRID_ROW_GAP.None,
        FooterLink: GRID_ROW_GAP.None,
        InAppPurchaseLockup: GRID_ROW_GAP.None,
        LargeBrick: {
            xsmall: 24,
            small: 24,
            medium: 24,
            large: 24,
            xlarge: 24,
        },
        LargeLockup: {
            xsmall: 20,
            small: 20,
            medium: 20,
            large: 20,
            xlarge: 20,
        },
        MediumLockup: {
            xsmall: 24,
            small: 24,
            medium: 24,
            large: 24,
            xlarge: 24,
        },
        PosterLockup: GRID_ROW_GAP.None,
        ScreenshotLarge: GRID_ROW_GAP.None,
        ScreenshotVision: GRID_ROW_GAP.None,
        ScreenshotPhone: GRID_ROW_GAP.None,
        ScreenshotPad: GRID_ROW_GAP.None,
        SearchLink: {
            xsmall: 10,
            small: 20,
            medium: 20,
            large: 20,
            xlarge: 20,
        },
        SearchResult: {
            xsmall: 24,
            small: 24,
            medium: 24,
            large: 24,
            xlarge: 24,
        },
        SmallLockup: {
            xsmall: 24,
            small: 24,
            medium: 24,
            large: 24,
            xlarge: 24,
        },
        SmallLockupWithOrdinal: {
            xsmall: 24,
            small: 24,
            medium: 24,
            large: 24,
            xlarge: 24,
        },
        SmallStoryCard: GRID_ROW_GAP.None,
        ProductBadge: GRID_ROW_GAP.None,
    },
    GRID_COL_GAP: {
        ProductBadge: { small: '20', medium: '0', large: '0', xlarge: '0' },
    },
});
