"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetricsFieldsAggregator = void 0;
const optional_1 = require("@jet/environment/types/optional");
const page_metrics_fields_provider_1 = require("../field-providers/page-metrics-fields-provider");
class MetricsFieldsAggregator {
    constructor() {
        this.optInProviders = new Map();
        this.optOutProviders = new Map();
    }
    static makeDefaultAggregator() {
        const aggregator = new MetricsFieldsAggregator();
        aggregator.addOptInProvider(new page_metrics_fields_provider_1.PageMetricsFieldsProvider(), "pageFields");
        return aggregator;
    }
    addOptInProvider(provider, request) {
        this.optInProviders.set(request, provider);
    }
    addOptOutProvider(provider, request) {
        this.optOutProviders.set(request, provider);
    }
    removeOptInProvider(request) {
        this.optInProviders.delete(request);
    }
    removeOptOutProvider(request) {
        this.optOutProviders.delete(request);
    }
    addMetricsFields(options) {
        options.including.forEach((request) => {
            const provider = this.optInProviders.get(request);
            if (optional_1.isNothing(provider)) {
                // No provider registered
                return;
            }
            provider.addMetricsFields(options.builder, options.context);
        });
        this.optOutProviders.forEach((provider, request) => {
            if (optional_1.isNothing(provider) || options.excluding.includes(request)) {
                return;
            }
            provider.addMetricsFields(options.builder, options.context);
        });
    }
}
exports.MetricsFieldsAggregator = MetricsFieldsAggregator;
