"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.JetBag = void 0;
class JetBag {
    constructor(backing) {
        this.backing = backing;
    }
    registerBagKeys() {
        // do nothing.
    }
    string(key) {
        const value = this.backing[key];
        return typeof value === "string" || value === null ? value : undefined;
    }
    double(key) {
        const value = this.backing[key];
        return typeof value === "number" || value === null ? value : undefined;
    }
    integer(key) {
        const value = this.backing[key];
        return typeof value === "number" || value === null ? value : undefined;
    }
    boolean(key) {
        const value = this.backing[key];
        return typeof value === "boolean" || value === null ? value : undefined;
    }
    array(key) {
        const value = this.backing[key];
        return Array.isArray(value) || value === null ? value : undefined;
    }
    dictionary(key) {
        const value = this.backing[key];
        return typeof value === "object" ? value : undefined;
    }
    url(key) {
        const value = this.backing[key];
        return typeof value === "string" ? value : undefined;
    }
}
exports.JetBag = JetBag;
