"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.difference = exports.symmetricDifference = exports.intersection = exports.union = exports.isSuperset = void 0;
/**
 * Test if a Set contains all elements of another Set.
 *
 * @param set -
 * @param subset -
 *
 * @returns True if set contains all elements of subset, otherwise false.
 */
function isSuperset(set, subset) {
    for (const elem of subset) {
        if (!set.has(elem)) {
            return false;
        }
    }
    return true;
}
exports.isSuperset = isSuperset;
/**
 * Construct the union of two Sets.
 *
 * @param setA -
 * @param setB -
 *
 * @returns A new Set containing all elements from setA and setB.
 */
function union(setA, setB) {
    const result = new Set(setA);
    for (const elem of setB) {
        result.add(elem);
    }
    return result;
}
exports.union = union;
/**
 * Construct the intersection of two Sets.
 *
 * @param setA -
 * @param setB -
 *
 * @returns A new Set containing only those elements which appear in both setA and setB.
 */
function intersection(setA, setB) {
    const result = new Set();
    for (const elem of setB) {
        if (setA.has(elem)) {
            result.add(elem);
        }
    }
    return result;
}
exports.intersection = intersection;
/**
 * Construct the symmetric difference (XOR) of two Sets.
 *
 * @param setA -
 * @param setB -
 *
 * @returns A new Set containing only those elements which appear in setA or in setB but not in both setA and setB.
 */
function symmetricDifference(setA, setB) {
    const result = new Set(setA);
    for (const elem of setB) {
        if (result.has(elem)) {
            result.delete(elem);
        }
        else {
            result.add(elem);
        }
    }
    return result;
}
exports.symmetricDifference = symmetricDifference;
/**
 * Construct the difference of two Sets.
 *
 * @param setA -
 * @param setB -
 *
 * @returns A new Set containing the elements of setA which do not appear in setB.
 */
function difference(setA, setB) {
    const result = new Set(setA);
    for (const elem of setB) {
        result.delete(elem);
    }
    return result;
}
exports.difference = difference;
//# sourceMappingURL=set.js.map