"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RewindableValue = void 0;
const clone_1 = require("./clone");
/* eslint-disable no-underscore-dangle */
/**
 * A lightweight wrapper around a primitive value which allows its state
 * to saved and later restored.
 */
class RewindableValue {
    /**
     * Create a rewindable value.
     *
     * @param initialValue - The initial value for the new instance.
     */
    constructor(initialValue) {
        this._values = [initialValue];
    }
    /**
     * Returns the current value of this instance.
     */
    get() {
        return this._values[this._values.length - 1];
    }
    /**
     * Replace the current value of this instance.
     *
     * @param newValue - The value to assign this instance.
     */
    set(newValue) {
        this._values[this._values.length - 1] = newValue;
    }
    /**
     * Save the current state of this value.
     *
     * Calls to this method should be balanced by calls to `restore`.
     */
    save() {
        this._values.push(this._values[this._values.length - 1]);
    }
    /**
     * Restore a previously saved value.
     */
    restore() {
        if (this._values.length === 1) {
            throw new RangeError("Calls to restore must balance previous calls to save");
        }
        this._values.pop();
    }
    // section Cloneable
    clone() {
        const copy = (0, clone_1.shallowCloneOf)(this);
        copy._values = this._values.slice();
        return copy;
    }
}
exports.RewindableValue = RewindableValue;
//# sourceMappingURL=rewindable-value.js.map