"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.shallowCloneOf = void 0;
/**
 * Create a copy of a given object without copying any of its members.
 *
 * Use this function to efficiently copy an object for your
 * implementation of the `Clone` interface.
 *
 * @param object - An object to create a shallow copy of.
 * @returns A new shallow copy of `object`.
 */
function shallowCloneOf(object) {
    const copy = Object.create(Object.getPrototypeOf(object));
    return Object.assign(copy, object);
}
exports.shallowCloneOf = shallowCloneOf;
//# sourceMappingURL=clone.js.map