"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LegacyRuntime = exports.Runtime = void 0;
const isJetEnvironment = typeof exportService === "function";
function nativeExportService(name, service) {
    exportService(name, service);
}
class Runtime {
    constructor(dispatcher, objectGraph) {
        this.dispatcher = dispatcher;
        this.objectGraph = objectGraph;
    }
    async dispatch(intent) {
        return await this.dispatcher.dispatch(intent, this.objectGraph);
    }
}
exports.Runtime = Runtime;
class LegacyRuntime extends Runtime {
    constructor(dispatcher, objectGraph, services) {
        super(dispatcher, objectGraph);
        this.services = services;
    }
    serviceWithName(name) {
        return this.services[name];
    }
    exportingService(name, service) {
        if (isJetEnvironment) {
            nativeExportService(name, service);
        }
        this.services[name] = service;
        return this;
    }
}
exports.LegacyRuntime = LegacyRuntime;
//# sourceMappingURL=runtime.js.map