"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.makeRouterUsingRegisteredControllers = void 0;
const route_provider_1 = require("./route-provider");
const router_1 = require("./router");
/**
 * Creates a new router using the routes from any controller registered on the provided
 * dispatcher that conforms to `RouteProvider`.
 * @param dispatcher - The dispatcher to get the controllers from.
 * @param objectGraph - An object graph for dependency injection.
 */
function makeRouterUsingRegisteredControllers(dispatcher, objectGraph) {
    const router = new router_1.Router();
    for (const controller of dispatcher.registeredControllers) {
        if ((0, route_provider_1.isRouteProvider)(controller)) {
            (0, route_provider_1.registerRoutesProvider)(router, controller, objectGraph);
        }
    }
    return router;
}
exports.makeRouterUsingRegisteredControllers = makeRouterUsingRegisteredControllers;
//# sourceMappingURL=router-factory.js.map