"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.traverse = void 0;
const optional_1 = require("../../types/optional");
const key_path_1 = require("./key-path");
function traverse(object, keyPath) {
    if (typeof object !== "object") {
        return object;
    }
    if (!(0, optional_1.isSome)(object)) {
        return object;
    }
    const keys = (0, key_path_1.keysOf)(keyPath);
    switch (keys.length) {
        case 0:
            return object;
        case 1:
            return object[keys[0]];
        default:
            // eslint-disable-next-line no-case-declarations
            let currentObject = object;
            for (const key of keys) {
                const currentValue = currentObject[key];
                if (typeof currentValue !== "object") {
                    return currentValue;
                }
                if (!(0, optional_1.isSome)(currentValue)) {
                    return currentValue;
                }
                currentObject = currentValue;
            }
            return currentObject;
    }
}
exports.traverse = traverse;
//# sourceMappingURL=traverse.js.map