"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PageMetricsPresenter = void 0;
const optional_1 = require("@jet/environment/types/optional");
class PageMetricsPresenter {
    constructor(metricsPipeline) {
        this.metricsPipeline = metricsPipeline;
        this.isViewAppeared = false;
    }
    set pageMetrics(pageMetrics) {
        this.pageMetricsStore = pageMetrics;
        if (optional_1.isSome(pageMetrics) && this.isViewAppeared) {
            void this.processInstructions("pageEnter");
        }
    }
    get pageMetrics() {
        return this.pageMetricsStore;
    }
    async processInstructions(invocationPoint) {
        var _a, _b, _c;
        if (optional_1.isNothing(this.pageMetrics)) {
            return;
        }
        // istanbul ignore next
        const invocationContext = {
            customMetrics: (_a = this.baseContext) === null || _a === void 0 ? void 0 : _a.customMetrics,
            pageFields: {
                ...(_b = this.baseContext) === null || _b === void 0 ? void 0 : _b.pageFields,
                ...(_c = this.pageMetrics) === null || _c === void 0 ? void 0 : _c.pageFields,
            },
        };
        await Promise.all(this.pageMetrics.instructions.map((instruction) => {
            const { invocationPoints } = instruction;
            if (invocationPoints.length === 0 || !invocationPoints.includes(invocationPoint)) {
                return;
            }
            // eslint-disable-next-line @typescript-eslint/no-floating-promises
            return this.metricsPipeline.process(instruction.data, invocationContext);
        }));
    }
    async didEnterPage() {
        this.isViewAppeared = true;
        if (optional_1.isSome(this.pageMetrics)) {
            await this.processInstructions("pageEnter");
        }
    }
    async didLeavePage() {
        await this.processInstructions("pageExit");
        this.isViewAppeared = false;
    }
}
exports.PageMetricsPresenter = PageMetricsPresenter;
