"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetricsPipeline = exports.FlushBehavior = void 0;
const metrics_fields_builder_1 = require("./aggregating/metrics-fields-builder");
var FlushBehavior;
(function (FlushBehavior) {
    FlushBehavior[FlushBehavior["automatic"] = 0] = "automatic";
    FlushBehavior[FlushBehavior["never"] = 1] = "never";
})(FlushBehavior = exports.FlushBehavior || (exports.FlushBehavior = {}));
class MetricsPipeline {
    constructor(options) {
        var _a;
        this.aggregator = options.aggregator;
        this.linter = options.linter;
        this.recorder = options.recorder;
        this.flushBehavior = (_a = options.flushBehavior) !== null && _a !== void 0 ? _a : FlushBehavior.automatic;
    }
    async process(data, context) {
        const builder = new metrics_fields_builder_1.SimpleMetricsFieldsBuilder(data.fields);
        this.aggregator.addMetricsFields({
            including: data.includingFields,
            excluding: data.excludingFields,
            builder: builder,
            context: context,
        });
        const lintedEvent = await this.linter.processEvent(builder.allMetricsFields);
        this.recorder.record(lintedEvent, data.topic);
        if (data.shouldFlush && this.flushBehavior === FlushBehavior.automatic) {
            void this.recorder.flush();
        }
        return lintedEvent;
    }
}
exports.MetricsPipeline = MetricsPipeline;
