/**
 * Creates and returns a mock Storage object.
 * @return A new mock Storage object.
 */
import { makeMetatype } from "@jet/environment/util/metatype";
import { Wrapper } from "./wrapper";
export class StorageWrapper extends Wrapper {
    retrieveString(key) {
        const value = this.implementation.retrieveString(key);
        if ((value === null || value === void 0 ? void 0 : value.length) > 0 && value !== "<null>") {
            return value;
        }
        else {
            return null;
        }
    }
    storeString(key, value) {
        this.implementation.storeString(value, key); // flip is deliberate.
    }
}
StorageWrapper.type = makeMetatype("app-store:storage-wrapper");
//# sourceMappingURL=storage.js.map