/**
 * Created by keithpk on 4/2/17.
 */
import { makeMetatype } from "@jet/environment/util/metatype";
import * as serverData from "../json-parsing/server-data";
import { Wrapper } from "./wrapper";
export class PropertiesWrapper extends Wrapper {
    /**
     * Returns the raw underlying value for the key path
     * @param path The path of the property to lookup
     * @return {JSONValue | null} The resulting value or null
     */
    value(path) {
        return serverData.traverse(this.implementation, path);
    }
    /**
     * Returns whether a property is enabled or not. This also
     * looks in the clientFeatures key as well for client-enabled
     * features
     *
     * @param key The key to look up
     * @return {boolean} The boolean result or false if no value was found for the key
     */
    enabled(key) {
        const propertyValue = this.value(key);
        if (typeof propertyValue !== "undefined") {
            return Boolean(propertyValue);
        }
        return Boolean(this.implementation.clientFeatures[key]);
    }
    /**
     * Syntactic sugar for !enabled(key).
     *
     * @param key The key to look up
     * @return {boolean} The boolean result or true if no value was found for the key
     */
    isNotEnabled(key) {
        return !this.enabled(key);
    }
    /**
     * Returns the value of the path coerced as a dictionary
     * @param path The path to look up
     * @return {JSONData|null} The dictionary or null if not found
     */
    asDictionary(path) {
        return serverData.asDictionary(this.implementation, path);
    }
    /**
     * Returns the value of the path coerced as a string
     * @param path The path to look up
     * @return {string|null} The string or null if not found
     */
    asString(path) {
        return serverData.asString(this.implementation, path);
    }
    /**
     * Returns the value of the path coerced as a number
     * @param path The path to look up
     * @return {string|null} The number or null if not found
     */
    asNumber(path) {
        return serverData.asNumber(this.implementation, path);
    }
    /**
     * Returns the value of the path coerced as an array
     * @param path The path to look up
     * @return {string|null} The array or empty if not found
     */
    asArray(path) {
        return serverData.asArrayOrEmpty(this.implementation, path);
    }
}
PropertiesWrapper.type = makeMetatype("app-store:props-wrapper");
//# sourceMappingURL=properties.js.map