/**
 * Created by dersu on 6/23/17.
 */
import { makeMetatype } from "@jet/environment/util/metatype";
import { Wrapper } from "./wrapper";
export class ClientOrderingWrapper extends Wrapper {
    async orderedVisibleIAPs(appBundleId, defaultOrdering, defaultVisibleIdentifiers, spotlightIdentifier) {
        return await new Promise((resolve, reject) => {
            // Collections that are parameters over the bridge cannot have `nil` constituents on the other side, so we
            // should make sure we don't give such inputs or else we'll crash the app.
            const cleanedDefaultOrdering = defaultOrdering.filter((item) => {
                return item !== null && item !== undefined;
            });
            const cleanedDefaultVisibleIdentifiers = defaultVisibleIdentifiers.filter((item) => {
                return item !== null && item !== undefined;
            });
            this.implementation.orderedVisibleIAPs(appBundleId, cleanedDefaultOrdering, cleanedDefaultVisibleIdentifiers, spotlightIdentifier, (ordering, error) => {
                if (error) {
                    reject(error);
                }
                else {
                    resolve(ordering);
                }
            });
        });
    }
    async visibilityForIAPs(productMap) {
        return await new Promise((resolve, reject) => {
            this.implementation.visibilityForIAPs(productMap, (visibilities, error) => {
                if (error) {
                    // Do not reject; we should gracefully fail, since this ordering
                    // data isn't strictly necessary to render search results.
                    resolve({});
                }
                else {
                    resolve(visibilities);
                }
            });
        });
    }
}
ClientOrderingWrapper.type = makeMetatype("app-store:client-ordering-wrapper");
//# sourceMappingURL=client-ordering.js.map