/**
 * Created by km on 1/9/17.
 */
import { isSome } from "@jet/environment";
import { makeMetatype } from "@jet/environment/util/metatype";
import * as serverData from "../json-parsing/server-data";
import { Wrapper } from "./wrapper";
import { CachedBag } from "./cached-bag";
export class BagWrapper extends Wrapper {
    constructor(bag, host) {
        super(new CachedBag(bag));
        this.underlyingBag = bag;
    }
    /// The boolean for whether today ad medium lockup screenshots are enabled
    get todayAdMediumLockupScreenshotEnabled() {
        var _a;
        return (_a = this.implementation.boolean("today-ad-medium-lockup-screenshots-enabled")) !== null && _a !== void 0 ? _a : false;
    }
    get todayAdMediumLockupScreenshotAnimationEnabled() {
        var _a;
        return (_a = this.implementation.boolean("today-ad-medium-lockup-screenshots-animation-enabled")) !== null && _a !== void 0 ? _a : true;
    }
    /// The URL for the trending searches endpoint.
    get trendingSearchesURL() {
        return this.implementation.url("trending-searches");
    }
    /// The URL for the search hints endpoint.
    get searchHintsURL() {
        return this.implementation.url("searchHints");
    }
    /// The URL for fetching a personalized review
    get personalizedUserReviewURL() {
        return this.implementation.url("personalizedUserReviewUrl");
    }
    /// The boolean for whether personalized reviews are enabled
    get personalizedUserReviewEnabled() {
        return this.implementation.boolean("personalizedUserReviewEnabled");
    }
    /// The URL for posting tap-to-rate requests.
    get userRateURL() {
        return this.implementation.url("p2-application-user-rate-content");
    }
    /// The URL for posting write review requests.
    get writeReviewURL() {
        return this.implementation.url("p2-application-user-write-review");
    }
    /// The base URL for accessory rooms
    get accessoryRoomURL() {
        return this.implementation.url("p2-accessory-room");
    }
    /// The URL for passbook main room
    get passbookMainURL() {
        return this.implementation.url("passbook");
    }
    /// The URL for library-link room
    get libraryLinkURL() {
        return this.implementation.url("library-link");
    }
    /// The metrics configuration for mt-metrics kit integration
    get metricsConfiguration() {
        return serverData.asJSONData(this.implementation.dictionary("metrics"));
    }
    // When the metrics payment topic is enabled the clientId and userId are on a separate namespace.
    get metricsPaymentNamespaceEnabled() {
        if (serverData.isNullOrEmpty(this.metricsPaymentTopic)) {
            return false;
        }
        const identifiers = serverData.asJSONData(this.implementation.dictionary("metrics-identifiers"));
        const metricsNameSpace = serverData.asDictionary(identifiers, "APPSTORE_PAYMENTS_ENGAGEMENT");
        const metricsClientIdSpace = serverData.asDictionary(identifiers, "APPSTORE_PAYMENTS_ENGAGEMENT_CLIENT");
        return (isSome(metricsNameSpace) &&
            metricsNameSpace.length !== 0 &&
            isSome(metricsClientIdSpace) &&
            metricsClientIdSpace.length !== 0);
    }
    // The Payment topic if one is provided by the bag. Otherwise the default one will be used
    get metricsPaymentTopic() {
        var _a, _b;
        if (preprocessor.GAMES_TARGET) {
            return (_a = serverData.asString(this.metricsConfiguration, "topics.GAMES_PAYMENTS_ENGAGEMENT_TOPIC")) !== null && _a !== void 0 ? _a : null;
        }
        else {
            return (_b = serverData.asString(this.metricsConfiguration, "topics.APPSTORE_PAYMENTS_ENGAGEMENT_TOPIC")) !== null && _b !== void 0 ? _b : null;
        }
    }
    // Whether the personalization user id has been inlcuded in the metrics identifiers bag entry
    get personalizationUserIdEnabled() {
        const identifiers = serverData.asJSONData(this.implementation.dictionary("metrics-identifiers"));
        const personalizationIdNameSpace = serverData.asDictionary(identifiers, "APPSTORE_PERSONALIZATION");
        return isSome(personalizationIdNameSpace) && Object.keys(personalizationIdNameSpace).length !== 0;
    }
    /// The language for the users storefront
    get language() {
        return this.implementation.string("language");
    }
    /// The language for media API
    get mediaApiLanguage() {
        const languageTag = this.implementation.string("language-tag");
        if (languageTag) {
            return languageTag;
        }
        return this.implementation.string("language");
    }
    /// The URL for terms and conditions page
    get termsAndConditionsURL() {
        return this.implementation.url("p2-service-terms-url");
    }
    /// whether we should send iAd data as a post request
    get usePostForAppStoreSearch() {
        return this.implementation.boolean("usePostForAppStoreSearch");
    }
    /// Whether or not monetary gifting is enabled.
    get isMonetaryGiftingEnabled() {
        return this.implementation.boolean("isBuyingScheduledGiftCertificateEnabled");
    }
    /// The URL for Account Top-Up in the finance sheet.
    get accountTopUpURL() {
        return this.implementation.url("AddFundsUrl");
    }
    /// The title for Account Top-Up in the finance sheet.
    get accountTopUpTitle() {
        return this.implementation.string("account-top-up-title");
    }
    /// Whether or not content gifting is enabled.
    get isContentGiftingEnabled() {
        return this.implementation.boolean("isScheduledGiftingEnabled");
    }
    /// The URL for buy button metadata.
    get buyButtonMetadataURL() {
        return this.implementation.url("personalized-buy-buttons/software");
    }
    /// Whether or not the current storefront supports the TV App.
    get isTVAppEnabled() {
        return this.implementation.boolean("uvSearch/nowplaying-enabled");
    }
    /// the url to send people to to email support
    get emailSupportLinkURL() {
        return this.implementation.url("supportLinkUrl");
    }
    /// The URL to report a review item helpful or not.
    get voteUrl() {
        return this.implementation.url("voteUrl");
    }
    /// Enables the Review Summary module
    get enableReviewSummarization() {
        return this.implementation.boolean("enable-review-summarization");
    }
    /// Provides configuration for Review Summary Report A Concern
    get reviewSummaryReportConcernData() {
        return serverData.asJSONData(this.implementation.dictionary("review-summarization-report-concern"));
    }
    /// The URL to report a concern about a review item.
    get reportConcernUrl() {
        return this.implementation.url("reportConcernUrl");
    }
    /// The explanation for the report a concern screen for a review.
    get reportConcernExplanation() {
        return this.implementation.string("reportConcernExplanation");
    }
    /// An array of reasons for reporting a concern for a review.
    get reportConcernReasons() {
        return serverData.asArrayOrEmpty(serverData.asJSONValue(this.implementation.array("reportConcernReasons")));
    }
    /// The boolean that enables report a problem.
    get reportProblemEnabled() {
        var _a;
        return (_a = this.implementation.boolean("product-page-report-problem-enabled")) !== null && _a !== void 0 ? _a : false;
    }
    /// The bag key that stores the report a problem URL.
    get productPageReportProblemURL() {
        return this.implementation.string("product-page-report-problem-url");
    }
    /// The string array of adamIDs of SAD apps with subscriptions.
    get productPageReportProblemSADSubscriptionArray() {
        return serverData.asArrayOrEmpty(serverData.asJSONValue(this.implementation.array("product-page-report-problem-sad-subscriptions")));
    }
    /// The string array of second party apps to not show the report a problem link for.
    /// We have added the array of IDs while we wait for bag key support. Removal is tracked by rdar://82606581 (Remove array of second party app ids from JS bag.)
    get productPageReportProblemSecondPartyAppArray() {
        const secondPartyAppArray = serverData.asArrayOrEmpty(serverData.asJSONValue(this.implementation.array("product-page-report-problem-second-party-apps")));
        const defaultSecondPartyAppArray = [
            "1473505534",
            "1416238567",
            "640199958",
            "1529498570",
            "915061776",
            "1130498044",
            "1070072560",
        ];
        if (serverData.isNullOrEmpty(secondPartyAppArray)) {
            return defaultSecondPartyAppArray;
        }
        return secondPartyAppArray;
    }
    /// The URL to create a new account.
    get createAccountUrl() {
        var _a;
        return ((_a = this.implementation.url("createAccountUrl")) !== null && _a !== void 0 ? _a : "https://buy.itunes.apple.com/WebObjects/MZFinance.woa/wa/signupWizard");
    }
    get mediaCountryCode() {
        return this.implementation.string("countryCode");
    }
    get mediaHost() {
        return this.implementation.url("apps-media-api-host");
    }
    mediaEdgeHost(objectGraph) {
        // The key has different type for AppStoreComponents
        // see <rdar://71290056>.
        if (objectGraph.host.clientIdentifier === "com.apple.appstorecomponentsd") {
            return this.implementation.url("apps-media-api-edge-host");
        }
        else {
            return this.implementation.string("apps-media-api-edge-host");
        }
    }
    get mediaAPICatalogMixedShouldUseEdge() {
        var _a;
        return (_a = this.implementation.boolean("apps-media-api-catalog-mixed-should-use-edge")) !== null && _a !== void 0 ? _a : false;
    }
    get mediaEdgeSearchHost() {
        return this.implementation.string("apps-media-api-search-edge-host");
    }
    get mediaPreviewHost() {
        return this.implementation.string("apps-media-api-preview-host");
    }
    get mediaRealmHost() {
        return this.implementation.string("notification-settings-media-api-host");
    }
    get edgeEndpoints() {
        return serverData.asArrayOrEmpty(serverData.asJSONValue(this.implementation.array("apps-media-api-edge-end-points")));
    }
    get mediaAdvertRequestLimit() {
        var _a;
        return (_a = this.implementation.double("apps-media-api-search-ads-limit")) !== null && _a !== void 0 ? _a : 4;
    }
    get searchSortOptions() {
        return serverData.asArrayOrEmpty(serverData.asJSONValue(this.implementation.array("searchSortOptions")));
    }
    get ageBands() {
        return serverData.asArrayOrEmpty(serverData.asJSONValue(this.implementation.array("ageBands")));
    }
    get redirectUrlWhitelistedQueryParams() {
        let params = serverData.asArrayOrEmpty(serverData.asJSONValue(this.implementation.array("processRedirectUrl/whitelistedQueryParams")));
        if (serverData.isNullOrEmpty(params)) {
            params = [
                "affC",
                "adId",
                "advp",
                "at",
                "ct",
                "itsct",
                "itscg",
                "itscc",
                "itcCt",
                "its_qt",
                "ls",
                "partnerId",
                "pt",
                "qtkid",
                "uo",
            ];
        }
        return params;
    }
    get redirectUrlEndpoint() {
        var _a;
        return ((_a = this.implementation.string("processRedirectUrl/endpoint")) !== null && _a !== void 0 ? _a : "https://itunes.apple.com/WebObjects/MZStoreServices.woa/wa/processRedirectUrl");
    }
    get aristotleParentAppAdamId() {
        var _a;
        return (_a = this.implementation.string("aristotle-app-id")) !== null && _a !== void 0 ? _a : "383941000";
    }
    /// The AdamId of the App Store app which owns the IAP for Arcade subscriptions
    get arcadeAppAdamId() {
        return this.implementation.string("app-store-app-id");
    }
    /// The product family of the Arcade subscription IAP. This is for multiple IAPs for the same service not family sharing.
    get arcadeProductFamilyId() {
        var _a;
        return (_a = this.implementation.string("arcade-iap-family-id")) !== null && _a !== void 0 ? _a : this.implementation.string("ocelot-iap-family-id");
    }
    /// The Identifier (developer supplied reverse dns style name) of the IAP for Arcade subscriptions
    get arcadeProductId() {
        var _a;
        return ((_a = this.implementation.string("arcade-iap-offer-name")) !== null && _a !== void 0 ? _a : this.implementation.string("ocelot-iap-offer-name"));
    }
    /// The percentage of users that will see the Arcade category bar See All Games uplift.
    get arcadeCategoryBarSAGUpliftDisplayRate() {
        var _a;
        return (_a = this.implementation.double("arcade-category-bar-see-all-games-display-rate")) !== null && _a !== void 0 ? _a : 0.0;
    }
    get isArcadeEnabled() {
        var _a;
        return (_a = this.implementation.boolean("arcade-enabled")) !== null && _a !== void 0 ? _a : false;
    }
    get isAppsGroupingTagsEnabled() {
        var _a;
        return (_a = this.implementation.boolean("apps-groupings-tags-enabled")) !== null && _a !== void 0 ? _a : false;
    }
    get isAppsProductPageTagsEnabled() {
        var _a;
        return (_a = this.implementation.boolean("apps-product-page-tags-enabled")) !== null && _a !== void 0 ? _a : false;
    }
    get isAppsSlpTagsEnabled() {
        var _a;
        return (_a = this.implementation.boolean("apps-slp-tags-enabled")) !== null && _a !== void 0 ? _a : false;
    }
    get searchResultsLearnMoreEditorialId() {
        return this.implementation.string("transparencyLawEditorialItemId");
    }
    /// An array containing a mapping of system app bundle IDs and adam IDs.
    get systemApps() {
        return serverData.asArrayOrEmpty(serverData.asJSONValue(this.implementation.array("hideableSystemApps")));
    }
    /// An array containing a mapping of system app bundle IDs and adam IDs
    /// Should only be used for watchOS as a temporary fix for rdar://100234873
    get nonDeletableSystemApps() {
        const apps = serverData.asJSONValue(this.implementation.array("nonDeletableSystemApps"));
        if (serverData.isDefinedNonNullNonEmpty(apps)) {
            return serverData.asArrayOrEmpty(apps);
        }
        else {
            return [
                { "id": 1635387927, "bundle-id": "com.apple.Depth" },
                { "id": 1635862301, "bundle-id": "com.apple.Mandrake" },
                { "id": 1584216343, "bundle-id": "com.apple.findmy.finddevices" },
                { "id": 1584215960, "bundle-id": "com.apple.NanoWorldClock" },
                { "id": 1584215812, "bundle-id": "com.apple.HeartRate" },
                { "id": 1584215851, "bundle-id": "com.apple.SessionTrackerApp" },
                { "id": 1146562108, "bundle-id": "com.apple.NanoPhone" },
                { "id": 1146560473, "bundle-id": "com.apple.MobileSMS" },
                { "id": 1584215428, "bundle-id": "com.apple.NanoPhotos" },
                { "id": 1459455352, "bundle-id": "com.apple.DeepBreathing" },
                { "id": 1067456176, "bundle-id": "com.apple.NanoCompass.watchkitapp" }, // Compass
            ];
        }
    }
    /// The standard tabs for the current storefront.
    get tabsStandard() {
        return serverData.asArrayOrEmpty(serverData.asJSONValue(this.implementation.array("tabs/standard")));
    }
    // URL to sub-in for deep links specifying the watch category. Note that this can be a multiplexing url.
    get watchAppsGroupingURL() {
        var _a;
        return ((_a = this.implementation.url("watchAppsGrouping")) !== null && _a !== void 0 ? _a : "https://apps.apple.com/WebObjects/MZStore.woa/wa/viewFeature?id=1472048385");
    }
    get requireAgeVerification() {
        return this.implementation.boolean("requireAgeVerification");
    }
    get ageRatingLearnMoreEditorialItemId() {
        return this.implementation.string("ageRatingLearnMoreEditorialItemId");
    }
    get appleSiliconMacUnverifiedBadgeEditorialItemId() {
        return this.implementation.string("appleSiliconMacUnverifiedBadgeEditorialItemId");
    }
    get safariExtensionsGroupingURL() {
        return this.implementation.url("safariExtensionsGrouping");
    }
    get familySubscriptionsLearnMoreEditorialItemId() {
        return this.implementation.string("familySubscriptionsLearnMoreEditorialItemId");
    }
    get dynamicUIRegexStrings() {
        return serverData.asArrayOrEmpty(serverData.asJSONValue(this.implementation.array("commerce-ui-urls/dynamic-url-patterns")));
    }
    get financeUIRegexStrings() {
        return serverData.asArrayOrEmpty(serverData.asJSONValue(this.implementation.array("commerce-ui-urls/url-patterns")));
    }
    get webViewRegexStrings() {
        return serverData.asArrayOrEmpty(serverData.asJSONValue(this.implementation.array("commerce-ui-urls/v2-url-patterns")));
    }
    get arcadePreOrderUpsellLimitSeconds() {
        var _a;
        return (_a = this.implementation.double("arcadePreOrderUpsellLimitSeconds")) !== null && _a !== void 0 ? _a : 86400;
    }
    get recentlyPlayedGamesWindowInSeconds() {
        var _a;
        return (_a = this.implementation.double("recentlyPlayedGamesWindowInSeconds")) !== null && _a !== void 0 ? _a : 7776000; // 90 days
    }
    get gamesFriendsPlayedWindowInSeconds() {
        var _a;
        return (_a = this.implementation.integer("games-friends-played-window-in-seconds")) !== null && _a !== void 0 ? _a : 15778800; // Half a year
    }
    get enableComingSoonToggle() {
        return this.implementation.boolean("enableComingSoonToggle");
    }
    /// Whether or not to show the app acessibility labels
    get enableAppAccessibilityLabels() {
        var _a;
        return (_a = this.implementation.boolean("enable-app-accessibility-labels")) !== null && _a !== void 0 ? _a : false;
    }
    /// Whether or not to show the app privacy labels
    get enablePrivacyNutritionLabels() {
        var _a;
        return (_a = this.implementation.boolean("enable-privacy-nutrition-labels")) !== null && _a !== void 0 ? _a : false;
    }
    /// Whether or not to show the seller info
    get enableSellerInfo() {
        var _a;
        return (_a = this.implementation.boolean("enable-seller-info")) !== null && _a !== void 0 ? _a : false;
    }
    // Whether or not to show the seller ICP annotation
    get enableSellerICPAnnotation() {
        var _a;
        return (_a = this.implementation.boolean("enable-seller-icp")) !== null && _a !== void 0 ? _a : false;
    }
    /// Whether to display enhanced category features (bar, breakout, and swoosh) on apps and games tabs
    get enableFeaturedCategoriesOnGroupings() {
        var _a;
        return (_a = this.implementation.boolean("enable-featured-categories-on-groupings")) !== null && _a !== void 0 ? _a : false;
    }
    /// Whether to display enhanced category bricks on apps and games tabs
    get enableCategoryBricksOnGroupings() {
        var _a;
        return (_a = this.implementation.boolean("enable-category-bricks-on-groupings")) !== null && _a !== void 0 ? _a : false;
    }
    get arcadeOfferEditorialItemId() {
        return this.implementation.string("arcadeOfferEditorialItemId");
    }
    get sponsoredSearchODMLTimeout() {
        var _a;
        return (_a = this.implementation.double("sponsored-search-odml-timeout")) !== null && _a !== void 0 ? _a : 3;
    }
    get isSearchLandingAdsEnabled() {
        var _a;
        return (_a = this.implementation.boolean("isSearchLandingAdsEnabled")) !== null && _a !== void 0 ? _a : false;
    }
    get isLLMSearchTagsEnabled() {
        var _a;
        return (_a = this.implementation.boolean("apps-search-tags-enabled")) !== null && _a !== void 0 ? _a : false;
    }
    get searchLandingAdFetchTimeout() {
        var _a;
        return (_a = this.implementation.double("search-landing-ad-fetch-timeout")) !== null && _a !== void 0 ? _a : 0.175;
    }
    // Time that SLP needs to be offscreen for it to be refreshed in seconds.
    get searchLandingPageOffscreenRefreshInterval() {
        var _a;
        return (_a = this.implementation.double("search-landing-offscreen-refresh-interval-in-seconds")) !== null && _a !== void 0 ? _a : 60; // default is minute
    }
    // Time to delay the data fetch for SLP when refreshing
    get searchLandingPageRefreshUpdateDelayInterval() {
        var _a;
        return (_a = this.implementation.double("search-landing-page-update-delay-interval-in-seconds")) !== null && _a !== void 0 ? _a : 0.3; // default is 0.3s
    }
    get appPrivacyLearnMoreEditorialItemId() {
        return this.implementation.string("appPrivacyLearnMoreEditorialItemId");
    }
    // The editorial id for the article page showing the transparency info for ratings and reviews
    get ratingsAndReviewsLearnMoreEditorialId() {
        return this.implementation.string("ratings-and-reviews-learn-more-editorial-item-id");
    }
    // The editorial id for the article page showing info about the review summary
    get reviewSummarizationLearnMoreEditorialItemId() {
        return this.implementation.string("review-summarization-learn-more-editorial-item-id");
    }
    /// An array containing a list of app bundle IDs and adam IDs for apps that should not display
    /// any app privacy shelves
    get suppressedPrivacyAppIds() {
        return serverData.asArrayOrEmpty(serverData.asJSONValue(this.implementation.array("suppressedPrivacyLabels")));
    }
    /// An array containing a list of app bundle IDs and adam IDs for apps that should not display
    /// any app accessibility shelves
    get suppressedAccessibilityAppIds() {
        return serverData.asArrayOrEmpty(serverData.asJSONValue(this.implementation.array("suppressed-accessibility-labels")));
    }
    get appPrivacyDefinitionsEditorialItemId() {
        return this.implementation.string("appPrivacyDefinitionsEditorialItemId");
    }
    // The EI ID for the web's category tabs shown in the sidebar
    get webNavigationCategoryTabsEditorialItemId() {
        return this.implementation.string("web-navigation-category-tabs-editorial-item-id");
    }
    /// The percentage of users that will see a live preview of the widget in the Widget Gallery
    get todayWidgetLivePreviewRolloutRate() {
        var _a;
        return (_a = this.implementation.double("todayWidgetLivePreviewRolloutRate")) !== null && _a !== void 0 ? _a : 1.0;
    }
    /// The percentage of users that will see the new carousel item styles under Hero 3.0
    get hero3RolloutRate() {
        var _a;
        return (_a = this.implementation.double("arcade-hero-shelf-tagline-style-rollout-rate")) !== null && _a !== void 0 ? _a : 1.0;
    }
    /// The percentage of users that will see the trial enrolled (subscriber) tab
    get arcadeTrialEnrolledStateRate() {
        var _a;
        return (_a = this.implementation.double("arcade-trial-enrolled-state-rate")) !== null && _a !== void 0 ? _a : 0.0;
    }
    get marketingItemSelectionTimeout() {
        var _a;
        return (_a = this.implementation.double("marketing-item-selection-timeout")) !== null && _a !== void 0 ? _a : 1.0;
    }
    /// Whether or not to enable app events
    get enableAppEvents() {
        var _a;
        return (_a = this.implementation.boolean("enableAppEvents")) !== null && _a !== void 0 ? _a : false;
    }
    /// Whether or not product page variants is enabled (feature-gate)
    get enableProductPageVariants() {
        var _a;
        return (_a = this.implementation.boolean("enableProductPageVariants")) !== null && _a !== void 0 ? _a : false;
    }
    get enableArcadeTrialEligibleBadging() {
        return this.implementation.boolean("enable-arcade-trial-eligible-badging");
    }
    /// The duration we should use for the hero carousel auto scrolling
    get heroCarouselAutoScrollDuration() {
        var _a;
        return (_a = this.implementation.double("heroCarouselAutoScrollDuration")) !== null && _a !== void 0 ? _a : 7.0;
    }
    /// Enable additional JS logging for Product Page Variants
    get enableAdditionalLoggingForPPV() {
        var _a;
        return (_a = this.implementation.boolean("enableAdditionalLoggingForPPV")) !== null && _a !== void 0 ? _a : false;
    }
    /// Whether or not to enable on device personalization
    get enableOnDevicePersonalization() {
        const enableOnDevicePersonalization = this.implementation.boolean("enable-on-device-personalization");
        if (serverData.isNull(enableOnDevicePersonalization)) {
            return true;
        }
        return enableOnDevicePersonalization;
    }
    /// Whether or not automatic page refreshing is enabled
    get enableAutomaticPageRefresh() {
        var _a;
        return (_a = this.implementation.boolean("enable-automatic-page-refresh")) !== null && _a !== void 0 ? _a : true;
    }
    /// Rollout rate for smart stack suggestions for the today widget.
    get widgetSuggestionsFromTodayTabRolloutRate() {
        var _a;
        return (_a = this.implementation.double("today-widget-suggestions-from-today-tab-rollout-rate")) !== null && _a !== void 0 ? _a : 1.0;
    }
    /// The upper bound for how many extra minutes we delay the smart stack from suggesting the Today Widget (to protect MAPI).
    get todayWidgetSmartStackJitterMinutes() {
        var _a;
        return (_a = this.implementation.double("today-widget-smart-stack-jitter-minutes")) !== null && _a !== void 0 ? _a : 45;
    }
    get enableSystemAppReviews() {
        var _a;
        return (_a = this.implementation.boolean("enable-system-app-reviews")) !== null && _a !== void 0 ? _a : false;
    }
    /// Whether or not CPPs are enabled for Search Ads.
    get enableCPPInSearchAds() {
        return this.implementation.boolean("enableCPPsInSearchAds") || false;
    }
    get cancelPreorderItemSrv() {
        return (this.implementation.url("cancelPreorderItemSrv") || "https://buy.itunes.apple.com/commerce/preorders/cancel");
    }
    get getCancellablePreorderItemsSrv() {
        return (this.implementation.url("getCancellablePreorderItemsSrv") ||
            "https://buy.itunes.apple.com/commerce/preorders/cancellable");
    }
    /// An array of the enabled ad placements.
    get enabledAdPlacements() {
        return serverData.asArrayOrEmpty(serverData.asJSONValue(this.implementation.array("enabled-ad-placements")));
    }
    /// A dictionary of timeout values for the ad placements.
    get adPlacementTimeouts() {
        return serverData.asDictionary(serverData.asJSONData(this.implementation.dictionary("ad-placement-timeouts")));
    }
    /// The editorial story ID for In App Purchases
    get inAppPurchasesLearnMoreEditorialItemId() {
        return this.implementation.string("in-app-purchases-learn-more-editorial-item-id");
    }
    /// Determines whether external purchases are enabled.
    get enableExternalPurchases() {
        var _a;
        return (_a = this.implementation.boolean("enable-external-purchase")) !== null && _a !== void 0 ? _a : false;
    }
    /// An array of the enabled external purchases placements
    get enabledExternalPurchasesPlacements() {
        return serverData.asArrayOrEmpty(serverData.asJSONValue(this.implementation.array("enabled-external-purchase-placements")));
    }
    /// The editorial item ID for the external purchases story
    get externalPurchasesLearnMoreEditorialItemId() {
        return this.implementation.string("external-purchase-learn-more-editorial-item-id");
    }
    /// The editorial item ID for the external browser story
    get externalBrowserLearnMoreEditorialItemId() {
        return this.implementation.string("external-browser-learn-more-editorial-item-id");
    }
    /// The SharePlay groupings url
    get sharePlayAppsEditorialItemId() {
        return this.implementation.string("share-play-apps-editorial-item-id");
    }
    /// Determines whether to show the icon on the external purchases product page banner
    get externalPurchasesIncludeProductPageBannerIcon() {
        var _a;
        return (_a = this.implementation.boolean("external-purchase-product-page-banner-include-icon")) !== null && _a !== void 0 ? _a : false;
    }
    /// Determines whether to use a variant of the external purchases product page annotation copy
    get externalPurchasesProductPageAnnotationVariant() {
        return this.implementation.string("external-purchase-product-page-annotation-variant");
    }
    /// Tells us whether we want new events for ODJ to be enabled or not.
    get newEventsForODJAreEnabled() {
        var _a;
        return (_a = this.implementation.boolean("new-events-for-odj-are-enabled")) !== null && _a !== void 0 ? _a : false;
    }
    get defaultChart() {
        return serverData.asJSONData(this.implementation.dictionary("default-chart"));
    }
    // The url to display the user account
    get accountUrl() {
        var _a;
        return ((_a = this.implementation.url("accountUrl")) !== null && _a !== void 0 ? _a : "https://buy.itunes.apple.com/WebObjects/MZFinance.woa/wa/accountSummary");
    }
    // The url to display the user account
    get redeemUrl() {
        var _a;
        return ((_a = this.implementation.url("redeemUrl")) !== null && _a !== void 0 ? _a : "https://buy.itunes.apple.com/WebObjects/MZFinance.woa/wa/redeemLandingPage");
    }
    // The url to display the user account
    get charityUrl() {
        var _a;
        return ((_a = this.implementation.url("charityUrl")) !== null && _a !== void 0 ? _a : "https://buy.itunes.apple.com/WebObjects/MZFinance.woa/wa/buyCharityGiftWizard");
    }
    // The url to display the manage subs page
    get manageSubscriptionsUrl() {
        var _a;
        return ((_a = this.implementation.url("manageSubscriptionsUrl")) !== null && _a !== void 0 ? _a : "https://finance-app.itunes.apple.com/subscriptions/manage?context=deeplink");
    }
    // The url to display the manage subs page
    get manageSubscriptionsV2Url() {
        var _a;
        return ((_a = this.implementation.url("manageSubscriptionsV2Url")) !== null && _a !== void 0 ? _a : "https://apps.mzstatic.com/content/54a1317a0ad442d3965d64ef6bfaae1c/");
    }
    /// The language value to use for ad language content filtering.
    /// This may not necessarily match the user's language setting - in some regions ads are required
    /// to be localized to the country's primary language, regardless of the user's own preferences.
    get adsOverrideLanguage() {
        return this.implementation.string("ads-override-language");
    }
    /// The percentage of users that will see the controller recommended or required treatment
    /// (as opposed to supported) on supported platforms.
    get gameControllerRecommendedRolloutRate() {
        var _a;
        return (_a = this.implementation.double("game-controller-recommended-rollout-rate")) !== null && _a !== void 0 ? _a : 0;
    }
    /// The ID of the editorial item that provides information about game controllers.
    get gameControllerLearnMoreEditorialItemId() {
        return this.implementation.string("game-controller-learn-more-editorial-item-id");
    }
    /// The ID of the editorial item that provides information about spatial controllers.
    get spatialControlsLearnMoreEditorialItemId() {
        return this.implementation.string("spatial-controllers-learn-more-editorial-item-id");
    }
    // Whether the user can use MAPI based search focus
    get mediaAPISearchFocusEnabled() {
        var _a;
        return (_a = this.implementation.boolean("apps-search-focus-suggestions-enabled")) !== null && _a !== void 0 ? _a : false;
    }
    /// Indicates whether the Search Landing Page supports the V2 protocol
    get supportsSearchLandingPageV2() {
        var _a;
        return (_a = this.implementation.boolean("supports-apps-slp-v2")) !== null && _a !== void 0 ? _a : false;
    }
    get enableSearchLandingPageV2ByTreatment() {
        var _a;
        return (_a = this.implementation.boolean("enable-apps-slp-v2-by-treatment")) !== null && _a !== void 0 ? _a : false;
    }
    /// The percentage of users that will see the new Search Landing Page V2 protocol
    get searchLandingPageV2RolloutRate() {
        var _a;
        return (_a = this.implementation.double("apps-slp-v2-rollout-rate")) !== null && _a !== void 0 ? _a : 0;
    }
    /// The percentage of users that will see the Today tab Arcade personalization
    get todayTabArcadePersonalizationRate() {
        var _a;
        return (_a = this.implementation.double("today-tab-arcade-personalization-rate")) !== null && _a !== void 0 ? _a : 0;
    }
    /// Whether to enable extending supported Game Center features.
    get gameCenterExtendSupportedFeatures() {
        var _a;
        return (_a = this.implementation.boolean("game-center-extend-supported-features")) !== null && _a !== void 0 ? _a : false;
    }
    get adPlacementEligibleSlotPositions() {
        const eligibleSlotPositions = serverData.asJSONData(this.implementation.dictionary("ad-placement-eligible-slot-positions"));
        if (serverData.isDefinedNonNullNonEmpty(eligibleSlotPositions)) {
            return eligibleSlotPositions;
        }
        return {
            "today": [
                {
                    shelfIdentifier: "0",
                    slot: 0,
                },
                {
                    shelfIdentifier: "0",
                    slot: 1,
                },
            ],
            "product-page-ymal": [
                {
                    shelfIdentifier: "customers-also-bought-apps",
                    slot: 0,
                },
            ],
        };
    }
    // The url to display the manage preorders page
    get managePreordersUrl() {
        var _a;
        return (_a = this.implementation.url("preordersUrl")) !== null && _a !== void 0 ? _a : "https://finance-app.itunes.apple.com/preorders";
    }
    // A url to modify the user's account.
    get modifyAccount() {
        var _a;
        return ((_a = this.implementation.url("modifyAccount")) !== null && _a !== void 0 ? _a : "https://buy.itunes.apple.com/WebObjects/MZFinance.woa/wa/accountSummary");
    }
    // The url to display the purchase history page
    get purchaseHistoryUrl() {
        return this.implementation.url("purchaseHistoryUrl");
    }
    // The url to display the ratings and reviews page
    get ratingsReviewsUrl() {
        var _a;
        return ((_a = this.implementation.url("ratingsReviewsUrl")) !== null && _a !== void 0 ? _a : "https://apps.mzstatic.com/content/54a1317a0ad442d3965d64ef6bfaae1c/ratings-reviews");
    }
    // A url to sign up for a new account.
    get signup() {
        var _a;
        return ((_a = this.implementation.url("signup")) !== null && _a !== void 0 ? _a : "https://buy.itunes.apple.com/WebObjects/MZFinance.woa/wa/signupWizard");
    }
    // The landing page to redeem a code.
    get redeemCodeLanding() {
        var _a;
        return ((_a = this.implementation.url("redeemCodeLanding")) !== null && _a !== void 0 ? _a : "https://buy.itunes.apple.com/WebObjects/MZFinance.woa/wa/redeemLandingPage");
    }
    /// The bag key that stores the generic report a problem URL.
    get reportProblemUrl() {
        return this.implementation.string("reportProblemUrl");
    }
    // Whether the app store should allow unrestricted arcade tab badging by server side marketing journeys
    get unrestrictedServerSideTabBadging() {
        var _a;
        return (_a = this.implementation.boolean("unrestricted-server-side-tab-badging")) !== null && _a !== void 0 ? _a : false;
    }
    // Whether all users should receive the "condensed" today ad.
    get todayAdCondensedEnabled() {
        var _a;
        return (_a = this.implementation.boolean("today-ad-condensed-enabled")) !== null && _a !== void 0 ? _a : false;
    }
    // Whether to enable bin-compat checks for the visionOS App Store
    get enableVisionAppStoreBinCompatChecks() {
        var _a;
        return (_a = this.implementation.boolean("enable-vision-app-store-bincompat-checks")) !== null && _a !== void 0 ? _a : false;
    }
    // The ID for an editorial page containing Safari Extensions
    get safariExtensionsEditorialPageId() {
        return this.implementation.url("safari-extensions-editorial-page-id");
    }
    /// The ID of the editorial item to show when deeplinking to buddy onboarding
    get buddyOnboardingEditorialItemId() {
        return this.implementation.string("buddy-onboarding-editorial-item-id");
    }
    // Whether click events should be sent for the friends playing shelf on the product page
    get productPageFriendsPlayingClickEventsEnabled() {
        var _a;
        return (_a = this.implementation.boolean("product-page-friends-playing-click-events-enabled")) !== null && _a !== void 0 ? _a : false;
    }
    // ID of the editorial item to show for more information about the "High Motion" annotation.
    get highMotionLearnMoreEditorialItemId() {
        return this.implementation.string("high-motion-learn-more-editorial-item-id");
    }
    // The speed of the river in the medium lockup with screenshots ad.
    // This is temporary, and only for testing purposes.
    get todayAdMediumLockupScreenshotsRiverSpeed() {
        return this.implementation.double("today-ad-medium-lockup-screenshots-river-speed");
    }
    // Collection ID of the game categories for Arcade download/starter pack onboarding.
    get arcadeDownloadPackCategoriesCollectionId() {
        return this.implementation.string("arcade-download-packs-onboarding-collection-id");
    }
    // Time interval in seconds where Arcade download pack shelf is visible after user has gone through the onboarding flow.
    get arcadeDownloadPackShelfTTLInSeconds() {
        var _a;
        return (_a = this.implementation.integer("arcade-starter-pack-ttl-in-seconds")) !== null && _a !== void 0 ? _a : 0;
    }
    // The feature flag as whether or not we should display IAP offers (eg winback offers).
    get enableOfferItems() {
        var _a;
        return (_a = this.implementation.boolean("enable-winback-offers")) !== null && _a !== void 0 ? _a : false;
    }
    // The host for App Distribution Media API requests.
    get appDistributionMediaAPIHost() {
        return this.implementation.string("app-distribution-media-api-host");
    }
    // The language tag to use for App Distribution Media API requests.
    get appDistributionLanguageTag() {
        return this.implementation.string("app-distribution-language-tag");
    }
    // Whether App Distribution is supported.
    get supportsAppDistribution() {
        var _a;
        return (_a = this.implementation.boolean("supports-app-distribution")) !== null && _a !== void 0 ? _a : false;
    }
    // Whether Arcade download/starter pack onboarding should be triggered after Arcade purchase from the page offer button.
    // When Mercury supports this flow the flag should be disabled.
    get arcadeDownloadPackPostSubscribeTrigger() {
        var _a;
        return (_a = this.implementation.boolean("arcade-download-packs-post-subscribe-trigger")) !== null && _a !== void 0 ? _a : true;
    }
    // The feature flag as whether or not we should display contingent offers.
    get enableContingentOffers() {
        var _a;
        return (_a = this.implementation.boolean("enable-contingent-offers")) !== null && _a !== void 0 ? _a : false;
    }
    /// The percentage of users that will see Arcade packs onboarding experience.
    get arcadeDownloadPackRolloutRate() {
        var _a;
        return (_a = this.implementation.double("arcade-download-packs-rollout-rate")) !== null && _a !== void 0 ? _a : 0;
    }
    // Whether to enable including the Vision platform in fetch requests
    get enableVisionPlatform() {
        var _a;
        return (_a = this.implementation.boolean("enable-vision-platform")) !== null && _a !== void 0 ? _a : false;
    }
    // Dictionary containing the use cases that are supported for mixed media requests.
    get supportedMixedMediaRequestUsecases() {
        var _a;
        return ((_a = serverData.asDictionary(serverData.asJSONData(this.implementation.dictionary("supported-mixed-media-request-usecases")))) !== null && _a !== void 0 ? _a : {});
    }
    // Whether the page and click events are enabled for Arcade download pack.
    get arcadeDownloadPacksMetricsEventsEnabled() {
        var _a;
        return (_a = this.implementation.boolean("arcade-download-packs-metrics-events-enabled")) !== null && _a !== void 0 ? _a : true;
    }
    // Whether the impression events are enabled for Arcade download pack.
    get arcadeDownloadPacksImpressionEventsEnabled() {
        var _a;
        return (_a = this.implementation.boolean("arcade-download-packs-impression-events-enabled")) !== null && _a !== void 0 ? _a : true;
    }
    /// The learn more EI ID for when purchasing a visionOS only app on iOS
    get visionOnlyAppLearnMoreEditorialItemId() {
        return this.implementation.string("vision-only-app-learn-more-editorial-item-id");
    }
    // Whether Arcade download pack onboarding will be shown after successful CIP carrier link.
    get arcadeDownloadPacksCIPDeeplinkIntegrationEnabled() {
        var _a;
        return (_a = this.implementation.boolean("arcade-download-packs-cip-deeplink-trigger")) !== null && _a !== void 0 ? _a : false;
    }
    // Whether Arcade download pack onboarding will be shown after Hardware upsell successful purchase.
    // Only for tab badge upsell.
    get arcadeDownloadPacksHardwareTabBadgeUpsellIntegrationEnabled() {
        var _a;
        return (_a = this.implementation.boolean("arcade-download-packs-hw-tabbadge-trigger")) !== null && _a !== void 0 ? _a : false;
    }
    // A URL that links to the About the App Store website
    get aboutAppStoreUrl() {
        return this.implementation.string("about-app-store-url");
    }
    // The EI ID for the About In App Purchases article
    get aboutInAppPurchasesEditorialItemId() {
        return this.implementation.string("about-in-app-purchases-editorial-item-id");
    }
    // A URL that links to the Request A Refund website
    get requestARefundUrl() {
        return this.implementation.string("request-a-refund-url");
    }
    // Whether the personalized recommendations toggle should be displayed in the personalized
    // recommendations screen.
    get personalizedRecommendationsToggleEnabled() {
        var _a;
        return (_a = this.implementation.boolean("enable-personalized-recommendations-toggle")) !== null && _a !== void 0 ? _a : false;
    }
    /// Whether we should be using metricsId exclusively and remove DSID in events
    get metricsIdMigrationEnabled() {
        var _a;
        return (_a = this.implementation.boolean("metrics-id-migration-enabled")) !== null && _a !== void 0 ? _a : true;
    }
    // Whether natural language search is enabled for all features, e.g. What's New, Bubble Tip, Hints, and Results.
    get isNaturalLanguageSearchEnabled() {
        var _a;
        return (_a = this.implementation.boolean("apps-natural-language-search-enabled")) !== null && _a !== void 0 ? _a : false;
    }
    // Whether natural language search is partially enabled, e.g. Bubble Tip and Results only, excludes What's New and Hints.
    get isNaturalLanguageSearchResultsEnabled() {
        var _a;
        return (_a = this.implementation.boolean("apps-natural-language-search-results-enabled")) !== null && _a !== void 0 ? _a : false;
    }
    /// Whether we should be using metricsId exclusively and remove DSID in events
    get metricsIdentifiersShouldCache() {
        var _a;
        return (_a = this.implementation.boolean("metrics-identifiers-should-cache")) !== null && _a !== void 0 ? _a : true;
    }
    // A URL that links to the Change Your Payment Method support article
    get changePaymentMethodUrl() {
        return this.implementation.string("change-payment-method-url");
    }
    // The EI ID for the Information about the French App Store article
    get aboutFrenchAppStoreEditorialItemId() {
        return this.implementation.string("about-app-store-editorial-item-id");
    }
    // A bag override which can disable product page on demand shelf fetching if necessary, without
    // a JS release
    get isOnDemandShelfFetchingEnabled() {
        var _a;
        return (_a = this.implementation.boolean("on-demand-product-shelf-fetching-enabled")) !== null && _a !== void 0 ? _a : true;
    }
    // A bag override which can enable the addition of the dsId field to metrics events in the case of
    // missing userId
    get isMetricsUserIdFallbackEnabled() {
        var _a;
        return (_a = this.implementation.boolean("metrics-user-id-fallback-enabled")) !== null && _a !== void 0 ? _a : false;
    }
    // A bag override which can enable the addition of the alt_ab2_data field to metrics events in the case of
    // missing ab2_data
    get isMetricsAb2DataFallbackEnabled() {
        var _a;
        return (_a = this.implementation.boolean("metrics-ab2data-fallback-enabled")) !== null && _a !== void 0 ? _a : !preprocessor.GAMES_TARGET;
    }
    /// Whether or not to enable on device reco reordering. Default to true while in dev.
    get enableRecoOnDeviceReordering() {
        var _a;
        return (_a = this.implementation.boolean("enable-on-device-reco-reordering")) !== null && _a !== void 0 ? _a : false;
    }
    // The EI IDs for any Vision Pro ribbon bar items
    get ribbonBarVisionEditorialItemIds() {
        return serverData.asArrayOrEmpty(serverData.asJSONValue(this.implementation.array("ribbon-bar-vision-editorial-item-ids")));
    }
    // The IDs for any EIs that should be filtered from search results
    get searchFilterEditorialItemIds() {
        const array = serverData.asArrayOrEmpty(serverData.asJSONValue(this.implementation.array("search-filter-editorial-item-ids")));
        return new Set(array);
    }
    // The ID for the accessibility learn more EI on the product page
    get accessibilityLearnMoreEditorialItemId() {
        return this.implementation.string("accessibility-learn-more-editorial-item-id");
    }
    /// Whether discovery content based on ownership of a Vision Pro device is enabled
    get enableDeviceDrivenDiscoveryContent() {
        var _a;
        return (_a = this.implementation.boolean("enable-device-driven-discovery-content")) !== null && _a !== void 0 ? _a : false;
    }
    /// Whether to show install size for apps on the product page
    get enableProductPageInstallSize() {
        var _a;
        return (_a = this.implementation.boolean("enable-product-page-install-size")) !== null && _a !== void 0 ? _a : false;
    }
    // Whether we show the prerendered icon artwork
    get enableIconArtwork() {
        var _a;
        return (_a = this.implementation.boolean("enable-icon-artwork")) !== null && _a !== void 0 ? _a : false;
    }
    // The rollout rate associated with `enable-icon-artwork`
    get iconArtworkRolloutRate() {
        var _a;
        return (_a = this.implementation.double("icon-artwork-rollout-rate")) !== null && _a !== void 0 ? _a : 0.0;
    }
    // Whether the new age rating system should be used
    get enableUpdatedAgeRatings() {
        var _a;
        return (_a = this.implementation.boolean("enable-app-store-age-ratings")) !== null && _a !== void 0 ? _a : false;
    }
    // Whether age rating should be sent to MAPI to filter returned content
    get enableAgeRatingFilter() {
        var _a;
        return (_a = this.implementation.boolean("enable-age-rating-filter")) !== null && _a !== void 0 ? _a : false;
    }
    // Whether two-phase buy is enabled. This is expected to always be false, and only exists
    // as an escape hatch.
    get enableTwoPhaseOfferConfirmation() {
        var _a;
        return (_a = this.implementation.boolean("enable-two-phase-offer-confirmation")) !== null && _a !== void 0 ? _a : false;
    }
    /// Determines whether to use a variant of the external purchases product page banner text copy
    get externalPurchasesProductPageBannerTextVariant() {
        return this.implementation.string("external-purchase-product-page-banner-text-variant");
    }
    /// Describes the variant of the external purchases product page banner icon to use
    get externalPurchasesProductPageBannerIconVariant() {
        return this.implementation.string("external-purchase-product-page-banner-icon-variant");
    }
    /** ******* GameStoreKit *********/
    // A default maximum number of games used for query events & updates.
    get maxGamesForFetchingEvents() {
        var _a;
        return (_a = this.implementation.integer("max-games-for-fetching-events")) !== null && _a !== void 0 ? _a : 30;
    }
    // The mock home feed url for testing
    get mockHomeFeedURL() {
        return this.implementation.string("mock-home-feed-url");
    }
    // Disable play-together endpoint
    get disablePlayTogetherEndpoint() {
        var _a;
        return (_a = this.implementation.boolean("disable-play-together-endpoint")) !== null && _a !== void 0 ? _a : false;
    }
    // Metrics topic for the current bundle.
    get metricsTopic() {
        var _a, _b;
        if (preprocessor.GAMES_TARGET) {
            const defaultTopic = "xp_amp_gc_cs";
            const metricsTopic = (_a = serverData.asString(this.metricsConfiguration, "topics.GAMES_CLICKSTREAM_TOPIC")) !== null && _a !== void 0 ? _a : null;
            return metricsTopic !== null && metricsTopic !== void 0 ? metricsTopic : defaultTopic;
        }
        else {
            const defaultTopic = "xp_ase_appstore_ue";
            return (_b = this.implementation.string("metrics_topic")) !== null && _b !== void 0 ? _b : defaultTopic;
        }
    }
    // A default collectionID of the game recommendations for arcade subscriber.
    get playTogetherGameRecommendationsArcade() {
        var _a;
        return (_a = this.implementation.string("play-together-arcade-game-recommendations")) !== null && _a !== void 0 ? _a : "1803255513";
    }
    // A default collectionID of the game recommendations for users with no arcade subscription.
    get playTogetherGameRecommendationsNonArcade() {
        var _a;
        return (_a = this.implementation.string("play-together-non-arcade-game-recommendations")) !== null && _a !== void 0 ? _a : "1804480915";
    }
    /// A collectionID of arcade game recommendations for multiplayer activity
    get multiplayerActivityGameRecommendationsArcade() {
        var _a;
        return (_a = this.implementation.string("multiplayer-activity-arcade-game-recommendations")) !== null && _a !== void 0 ? _a : "1821553042";
    }
    /// A collectionID of non-arcade game recommendations for multiplayer activity
    get multiplayerActivityGameRecommendationsNonArcade() {
        var _a;
        return (_a = this.implementation.string("multiplayer-activity-non-arcade-game-recommendations")) !== null && _a !== void 0 ? _a : "1821553152";
    }
    // Whether to show the Subscriber Access Arcade Badge
    get showArcadeSubscriberAccessBadge() {
        var _a;
        return (_a = this.implementation.boolean("show-arcade-subscriber-access-badge")) !== null && _a !== void 0 ? _a : false;
    }
    // Whether to show the Non-Subscriber Arcade Badge
    get showArcadeNonSubscriberBadge() {
        var _a;
        return (_a = this.implementation.boolean("show-arcade-non-subscriber-badge")) !== null && _a !== void 0 ? _a : false;
    }
    /// The URL for the learn more link on the Cross Use Consent screen.
    get gamesCrossUseConsentLearnMoreURL() {
        return this.implementation.string("games-crossuse-consent-learn-more-url");
    }
    /// The duration for the auto advance interval for the Play Now feed hero carousel
    get gamesPlayNowHeroCarouselAutoAdvanceInterval() {
        var _a;
        return (_a = this.implementation.double("games-play-now-hero-carousel-auto-advance-interval")) !== null && _a !== void 0 ? _a : 10.0;
    }
    /// The max duration for the auto advance interval for the Play Now feed hero carousel
    get gamesPlayNowHeroCarouselAutoAdvanceMaxInterval() {
        var _a;
        return (_a = this.implementation.double("games-play-now-hero-carousel-auto-advance-max-interval")) !== null && _a !== void 0 ? _a : 30.0;
    }
    /// The duration for the auto advance interval for the Editorial hero carousel
    get gamesEditorialHeroCarouselAutoAdvanceInterval() {
        var _a;
        return (_a = this.implementation.double("games-editorial-hero-carousel-auto-advance-interval")) !== null && _a !== void 0 ? _a : 10.0;
    }
    /// The max duration for the auto advance interval for the Editorial hero carousel
    get gamesEditorialHeroCarouselAutoAdvanceMaxInterval() {
        var _a;
        return (_a = this.implementation.double("games-editorial-hero-carousel-auto-advance-max-interval")) !== null && _a !== void 0 ? _a : 30.0;
    }
    get enablePreviewPlatformForWeb() {
        var _a;
        return (_a = this.implementation.boolean("enable-preview-platform-for-web")) !== null && _a !== void 0 ? _a : false;
    }
    // How long to look back for completed challenges to show in active challenges shelf
    get completedChallengesInActiveShelfTimeThreshold() {
        var _a;
        return (_a = this.implementation.integer("completed-challenges-in-active-shelf-time-threshold")) !== null && _a !== void 0 ? _a : 86400; // default to 1 day
    }
    // Whether we should request for a review when we have a chance.
    get requestReviewEnabled() {
        var _a;
        return (_a = this.implementation.boolean("request-review-enabled")) !== null && _a !== void 0 ? _a : true;
    }
    // The minimum number of app launches before we consider requesting for a review.
    get requestReviewMinAppLaunchCount() {
        var _a;
        return (_a = this.implementation.integer("request-review-min-app-launch-count")) !== null && _a !== void 0 ? _a : 15;
    }
    // The minimum number of game launches from the app before we consider requesting a review.
    get requestReviewMinGameLaunchCount() {
        var _a;
        return (_a = this.implementation.integer("request-review-min-game-launch-count")) !== null && _a !== void 0 ? _a : 5;
    }
    // Whether we should request licenses in product information
    get enableLicenses() {
        var _a;
        return (_a = this.implementation.boolean("enable-licenses")) !== null && _a !== void 0 ? _a : false;
    }
    // The number of apps to display in the chart detail screen.
    get chartDetailPageItemCount() {
        var _a;
        return (_a = this.implementation.integer("chart-detail-page-item-count")) !== null && _a !== void 0 ? _a : 25;
    }
    /// https://quip-apple.com/G5EGABrSh1YO#temp:C:UdDa344becf5aac473db8085f35a
    /// URL query parameters that are permitted to be included in the pageUrl field of page metrics events.
    get metricsAllowedListURLParams() {
        let params = serverData.asArrayOrEmpty(serverData.asJSONValue(this.implementation.array("metrics-allowed-list-url-params")));
        if (serverData.isNullOrEmpty(params)) {
            params = [
                "itsct",
                "itscg",
                "itcCt",
                "ct",
                "pt",
                "advp",
                "mttn3pid",
                "mttnagencyid",
                "mttncc",
                "mttnpid",
                "mttnsiteid",
                "mttnsub1",
                "mttnsub2",
                "mttnsubad",
                "mttnsubkw",
                "mttnsubplmnt",
                "id",
                "term",
                "salableAdamId",
                "ign-itscg",
                "ign-itsct",
                "utm_campaign",
                "clusterId",
            ];
        }
        return params;
    }
}
BagWrapper.type = makeMetatype("app-store:bag-wrapper");
//# sourceMappingURL=bag.js.map