/**
 * Given an integer m > 1, called a modulus, two integers are said to be congruent modulo m,
 * if m is a divisor of their difference (i.e., if there is an integer k such that a \u2212 b = km).
 *
 * Unlike JavaScript's remainder operator (%), this mod function never returns negative values.
 *
 * @param n An integer
 * @param m The modulous
 */
export function mod(n, m) {
    return ((n % m) + m) % m;
}
/**
 * Reduce sig fig of `value` to `significantDigits`.
 * @param value Value to reduce precision of.
 * @param significantDigits Significant digits to keep.
 */
export function reduceSignificantDigits(value, significantDigits) {
    const roundFactor = Math.pow(10.0, significantDigits);
    const roundingFunction = value > 0.0 ? Math.floor : Math.ceil;
    return roundingFunction(value / roundFactor) * roundFactor;
}
/**
 * Clamps a value between an upper and lower bound.
 * @param value The preferred value.
 * @param min The minimum allowed value.
 * @param max The maximum allowed value.
 */
export function clamp(value, min, max) {
    return Math.max(min, Math.min(max, value));
}
//# sourceMappingURL=math-util.js.map