/**
 * Creates an array containing multiple copies of the elements of another array.
 *
 * For example, if A = [Q, W, E, R, T, Y], then calling repeating(A, 3) would return
 * [Q, W, E, R, T, Y, Q, W, E, R, T, Y, Q, W, E, R, T, Y]
 *
 * @param elements The elements that will be repeated
 * @param times The number of times all of the elements should appear in the new array.
 */
export function arrayByRepeating(elements, times) {
    if (times <= 0) {
        return [];
    }
    let newArray = [];
    for (let i = 0; i < times; i++) {
        newArray = newArray.concat(elements);
    }
    return newArray;
}
export function partition(array, predicate) {
    const part1 = [];
    const part2 = [];
    array.forEach((item) => (predicate(item) ? part1.push(item) : part2.push(item)));
    return [part1, part2];
}
export function isEmpty(elements) {
    return elements.length === 0;
}
export function isNotEmpty(elements) {
    return !isEmpty(elements);
}
//# sourceMappingURL=array-util.js.map