import { ObjectGraph } from "@jet/environment/dependencies";
import { fetchTimingMetricsBuilderType, } from "@jet/environment/metrics/fetch-timing-metrics-builder";
import * as jetTypes from "@jet/environment/types/globals/types";
import * as askTypes from "../../api/typings/constants";
import { isDefinedNonNull } from "../json-parsing/server-data";
import { AppleSiliconWrapper } from "../wrappers/apple-silicon";
import { BagWrapper } from "../wrappers/bag";
import { ClientWrapper } from "../wrappers/client";
import { ClientOrderingWrapper } from "../wrappers/client-ordering";
import { ConsoleWrapper } from "../wrappers/console";
import { HostWrapper } from "../wrappers/host";
import { LocalizationWrapper } from "../wrappers/localization";
import { PropertiesWrapper } from "../wrappers/properties";
import { StorageWrapper } from "../wrappers/storage";
import { ExperimentCache } from "../experimentation/experiment-cache";
import { MetricsIdentifiersCache } from "../metrics/metrics-identifiers-cache";
import { LocaleMetaType } from "../dependencies/locale/locale";
import { SEOMetaType } from "../dependencies/seo";
import { ActiveIntentMetaType, ActiveIntent } from "../dependencies/active-intent";
import { LocaleFromBag } from "../dependencies/locale/locale-from-bag";
import { ObjectGraphType } from "../../gameservicesui/src/foundation/object-graph-types";
export class AppStoreObjectGraph extends ObjectGraph {
    configureDefaults(
    // Jet Types
    aBag, aCryptography, aHost, aNetwork, aPlatform, aPlist, aRandom, aServices, aCookieProvider, aConsole, 
    // Ask Types
    aStoreMetrics, aAMSEngagement, aLocalization, aAdsLocalizer, aDevice, aClient, aProperties, aUser, aPlayer, aMetricsIdentifiers, aClientOrdering, aArcade, aGameCenter, aResilientDeepLinks, aAppleSilicon, aStorage, aAds, aOnDeviceRecommendationsManager, aOnDeviceSearchHistoryManager, aFeatureFlags, aMediaToken, aAppDistribution, timeoutManager, treatmentStore, userDefaults) {
        let objectGraph = this
            // Jet Types
            .addingCryptography(aCryptography)
            .addingHost(aHost)
            .addingNetwork(aNetwork)
            .addingPlatform(aPlatform)
            .addingPlist(aPlist)
            .addingRandom(aRandom)
            .addingServices(aServices)
            .addingCookieProvider(aCookieProvider)
            .addingBag(aBag) // Bag depends on having Host
            .addingConsole(aConsole)
            // ASK types
            .addingStoreMetrics(aStoreMetrics)
            .addingAMSEngagement(aAMSEngagement)
            .addingLoc(aLocalization)
            .addingAdsLoc(aAdsLocalizer)
            .addingDevice(aDevice)
            .addingClient(aClient)
            .addingProperties(aProperties)
            .addingUser(aUser)
            .addingPlayer(aPlayer)
            .addingMetricsIdentifiers(aMetricsIdentifiers)
            .addingClientOrdering(aClientOrdering)
            .addingArcade(aArcade)
            .addingGameCenter(aGameCenter)
            .addingDeepLinks(aResilientDeepLinks)
            .addingAppleSilicon(aAppleSilicon)
            .addingStorage(aStorage)
            .addingAds(aAds)
            .addingOnDeviceRecommendationsManager(aOnDeviceRecommendationsManager)
            .addingOnDeviceSearchHistoryManager(aOnDeviceSearchHistoryManager)
            .addingFeatureFlags(aFeatureFlags)
            .addingMediaToken(aMediaToken)
            .addingAppDistribution(aAppDistribution)
            .addingTimeoutManager(timeoutManager)
            .addingAdsLoc(aAdsLocalizer)
            .addingTreatmentStore(treatmentStore)
            .addingUserDefaults(userDefaults);
        objectGraph.loc.load(objectGraph);
        // `LocaleFromBag` requires that the `bag` is already present on the Object Graph
        objectGraph = objectGraph.addingLocale(new LocaleFromBag(objectGraph));
        return objectGraph;
    }
    // Jet Types
    get bag() {
        return this.required(BagWrapper.type);
    }
    addingBag(bag) {
        return this.addingBagWrapper(new BagWrapper(bag, this.host)).adding(jetTypes.bag, bag);
    }
    addingBagWrapper(bag) {
        return this.adding(BagWrapper.type, bag);
    }
    get console() {
        return this.required(ConsoleWrapper.type);
    }
    addingConsole(console) {
        return this.addingConsoleWrapper(new ConsoleWrapper(console));
    }
    addingConsoleWrapper(console) {
        return this.adding(ConsoleWrapper.type, console);
    }
    get cryptography() {
        return this.required(jetTypes.cryptography);
    }
    addingCryptography(cryptography) {
        return this.adding(jetTypes.cryptography, cryptography);
    }
    get host() {
        return this.required(HostWrapper.type);
    }
    addingHost(host) {
        return this.addingHostWrapper(new HostWrapper(host));
    }
    addingHostWrapper(host) {
        return this.adding(HostWrapper.type, host);
    }
    get locale() {
        return this.required(LocaleMetaType);
    }
    addingLocale(locale) {
        return this.adding(LocaleMetaType, locale);
    }
    get network() {
        return this.required(jetTypes.net);
    }
    addingNetwork(network) {
        return this.adding(jetTypes.net, network);
    }
    get platform() {
        return this.required(jetTypes.platform);
    }
    addingPlatform(platform) {
        return this.adding(jetTypes.platform, platform);
    }
    get plist() {
        return this.required(jetTypes.plist);
    }
    addingPlist(plist) {
        return this.adding(jetTypes.plist, plist);
    }
    get random() {
        return this.required(jetTypes.random);
    }
    addingRandom(random) {
        return this.adding(jetTypes.random, random);
    }
    get services() {
        return this.required(jetTypes.services);
    }
    addingServices(services) {
        return this.adding(jetTypes.services, services);
    }
    get cookieProvider() {
        return this.required(jetTypes.cookieProvider);
    }
    addingCookieProvider(cookieProvider) {
        return this.adding(jetTypes.cookieProvider, cookieProvider);
    }
    get fetchTimingMetricsBuilder() {
        return this.optional(fetchTimingMetricsBuilderType);
    }
    addingFetchTimingMetricsBuilder(fetchTimingMetricsBuilder) {
        return this.adding(fetchTimingMetricsBuilderType, fetchTimingMetricsBuilder);
    }
    // Ask Types
    get storeMetrics() {
        return this.required(askTypes.storeMetrics);
    }
    addingStoreMetrics(storeMetrics) {
        return this.adding(askTypes.storeMetrics, storeMetrics);
    }
    get amsEngagement() {
        return this.optional(askTypes.amsEngagement);
    }
    addingAMSEngagement(amsEngagement) {
        return this.adding(askTypes.amsEngagement, amsEngagement);
    }
    get loc() {
        return this.required(LocalizationWrapper.type);
    }
    addingLoc(loc) {
        return this.addingLocWrapper(new LocalizationWrapper(loc, this));
    }
    addingLocWrapper(loc) {
        return this.adding(LocalizationWrapper.type, loc);
    }
    get adsLoc() {
        return this.required(askTypes.adsLocalizer);
    }
    addingAdsLoc(loc) {
        return this.adding(askTypes.adsLocalizer, loc);
    }
    get device() {
        return this.required(askTypes.device);
    }
    addingDevice(device) {
        return this.adding(askTypes.device, device);
    }
    get client() {
        return this.required(ClientWrapper.type);
    }
    addingClient(client) {
        return this.addingClientWrapper(new ClientWrapper(client));
    }
    addingClientWrapper(client) {
        return this.adding(ClientWrapper.type, client);
    }
    get props() {
        return this.required(PropertiesWrapper.type);
    }
    addingProperties(properties) {
        return this.addingPropertiesWrapper(new PropertiesWrapper(properties));
    }
    addingPropertiesWrapper(properties) {
        return this.adding(PropertiesWrapper.type, properties);
    }
    get user() {
        return this.required(askTypes.user);
    }
    addingUser(user) {
        return this.adding(askTypes.user, user);
    }
    /// Returns the current GameCenter player, only available for GAMES_TARGET
    get player() {
        if (preprocessor.GAMES_TARGET && this.props.enabled("157263806-add-playerBridge-askGlobal")) {
            return this.required(askTypes.player);
        }
        else {
            return undefined;
        }
    }
    addingPlayer(player) {
        return this.adding(askTypes.player, player);
    }
    get metricsIdentifiers() {
        return this.required(askTypes.metricsIdentifiers);
    }
    addingMetricsIdentifiers(metricsIdentifiers) {
        return this.adding(askTypes.metricsIdentifiers, metricsIdentifiers);
    }
    get clientOrdering() {
        return this.required(ClientOrderingWrapper.type);
    }
    addingClientOrdering(clientOrdering) {
        return this.addingClientOrderingWrapper(new ClientOrderingWrapper(clientOrdering));
    }
    addingClientOrderingWrapper(clientOrdering) {
        return this.adding(ClientOrderingWrapper.type, clientOrdering);
    }
    get arcade() {
        return this.required(askTypes.arcade);
    }
    addingArcade(arcade) {
        return this.adding(askTypes.arcade, arcade);
    }
    get gameCenter() {
        return this.required(askTypes.gameCenter);
    }
    addingGameCenter(gameCenter) {
        return this.adding(askTypes.gameCenter, gameCenter);
    }
    get deepLinks() {
        return this.required(askTypes.resilientDeepLinks);
    }
    addingDeepLinks(resilientDeepLinks) {
        return this.adding(askTypes.resilientDeepLinks, resilientDeepLinks);
    }
    get appleSilicon() {
        return this.required(AppleSiliconWrapper.type);
    }
    addingAppleSilicon(appleSilicon) {
        return this.addingAppleSiliconWrapper(new AppleSiliconWrapper(appleSilicon));
    }
    addingAppleSiliconWrapper(appleSilicon) {
        return this.adding(AppleSiliconWrapper.type, appleSilicon);
    }
    get storage() {
        return this.required(StorageWrapper.type);
    }
    addingStorage(storage) {
        return this.addingStorageWrapper(new StorageWrapper(storage));
    }
    addingStorageWrapper(storage) {
        return this.adding(StorageWrapper.type, storage);
    }
    get ads() {
        return this.required(askTypes.ads);
    }
    addingAds(ads) {
        return this.adding(askTypes.ads, ads);
    }
    get onDeviceRecommendationsManager() {
        return this.required(askTypes.onDeviceRecommendationsManager);
    }
    addingOnDeviceRecommendationsManager(onDeviceRecommendationsManager) {
        return this.adding(askTypes.onDeviceRecommendationsManager, onDeviceRecommendationsManager);
    }
    get onDeviceSearchHistoryManager() {
        return this.required(askTypes.onDeviceSearchHistoryManager);
    }
    addingOnDeviceSearchHistoryManager(onDeviceSearchHistoryManager) {
        return this.adding(askTypes.onDeviceSearchHistoryManager, onDeviceSearchHistoryManager);
    }
    get featureFlags() {
        return this.required(askTypes.featureFlags);
    }
    addingFeatureFlags(featureFlags) {
        return this.adding(askTypes.featureFlags, featureFlags);
    }
    get mediaToken() {
        return this.required(askTypes.mediaToken);
    }
    addingMediaToken(mediaToken) {
        return this.adding(askTypes.mediaToken, mediaToken);
    }
    get appDistribution() {
        return this.required(askTypes.appDistribution);
    }
    addingAppDistribution(appDistribution) {
        return this.adding(askTypes.appDistribution, appDistribution);
    }
    get timeoutManager() {
        return this.required(askTypes.timeoutManager);
    }
    addingTimeoutManager(timeoutManager) {
        return this.adding(askTypes.timeoutManager, timeoutManager);
    }
    get treatmentStore() {
        return this.required(askTypes.treatmentStore);
    }
    addingTreatmentStore(treatmentStore) {
        return this.adding(askTypes.treatmentStore, treatmentStore);
    }
    get experimentCache() {
        return this.optional(ExperimentCache.metatype);
    }
    get metricsIdentifiersCache() {
        return this.optional(MetricsIdentifiersCache.defaultMetatype);
    }
    get paymentMetricsIdentifiersCache() {
        return this.optional(MetricsIdentifiersCache.paymentMetatype);
    }
    get personalizationMetricsIdentifiersCache() {
        return this.optional(MetricsIdentifiersCache.personalizationMetatype);
    }
    get userDefaults() {
        if (!this.client.isiOS) {
            return undefined;
        }
        return this.required(askTypes.userDefaults);
    }
    addingUserDefaults(userDefaults) {
        return this.adding(askTypes.userDefaults, userDefaults);
    }
    isAvailable(type) {
        return isDefinedNonNull(this.optional(type));
    }
    // "Web" client dependencies
    get activeIntent() {
        return this.optional(ActiveIntentMetaType);
    }
    addingActiveIntent(implementation) {
        return this.adding(ActiveIntentMetaType, new ActiveIntent(implementation));
    }
    get seo() {
        return this.optional(SEOMetaType);
    }
    addingSEO(implementation) {
        return this.adding(SEOMetaType, implementation);
    }
    // GameStoreKit dependencies
    get dispatcher() {
        return this.required(ObjectGraphType.dispatcher);
    }
    get nativeIntentDispatcher() {
        return this.required(ObjectGraphType.nativeIntentDispatcher);
    }
    get debugSettings() {
        return this.required(ObjectGraphType.debugSettings);
    }
    get router() {
        return this.required(ObjectGraphType.router);
    }
    get localizer() {
        return this.required(ObjectGraphType.localizer);
    }
    get personNameComponentsFormatter() {
        return this.required(ObjectGraphType.personNameComponentsFormatter);
    }
}
//# sourceMappingURL=app-store-object-graph.js.map