import { IntentDispatcher } from "@jet/environment/dispatching";
import { ExperimentCache } from "../experimentation/experiment-cache";
import { MetricsIdentifiersCache, MetricsIdentifierType, paymentIdentifierContextMapping, personalizationIdentifierContextMapping, } from "../metrics/metrics-identifiers-cache";
import { AppStoreObjectGraph } from "./app-store-object-graph";
export class AppStoreIntentDispatcher {
    constructor() {
        this.dispatcher = new IntentDispatcher();
    }
    // MARK: - IBaseIntentDispatcher
    register(controller) {
        this.dispatcher.register(controller);
    }
    async dispatch(intent, objectGraph) {
        const intentObjectGraph = await this.createIntentObjectGraphWithAsyncValues(objectGraph);
        return await this.dispatcher.dispatch(intent, intentObjectGraph);
    }
    controller(intent) {
        return this.dispatcher.controller(intent);
    }
    get registeredControllers() {
        return this.dispatcher.registeredControllers;
    }
    async createIntentObjectGraphWithAsyncValues(objectGraph) {
        const experimentCache = new ExperimentCache();
        const metricsIdentifiersCache = new MetricsIdentifiersCache();
        const personalizationMetricsIdentifierCache = new MetricsIdentifiersCache(personalizationIdentifierContextMapping);
        let paymentMetricsIdentifiersCache;
        // Doing these in sequence to help minimize the liklihood of hitting the treatment store locking timeout
        // rdar://147518835 (AppStore Ad Regression Performance - Metrics Identifier blocking network requests)
        if (objectGraph instanceof AppStoreObjectGraph) {
            let appStoreObjectGraph = objectGraph;
            // reassigning the bag creates a fresh cache
            appStoreObjectGraph = appStoreObjectGraph.addingBag(appStoreObjectGraph.bag.underlyingBag);
            await experimentCache.loadTreatments(appStoreObjectGraph);
            await metricsIdentifiersCache.loadValues(appStoreObjectGraph, [
                MetricsIdentifierType.client,
                MetricsIdentifierType.user,
            ]);
            // Only load the values if the namespace is in the bag
            if (objectGraph.bag.personalizationUserIdEnabled) {
                await personalizationMetricsIdentifierCache.loadValues(objectGraph, [MetricsIdentifierType.user]);
            }
            // The payment topic uses a different metrics identifier cache as it has a separate namespace.
            if (appStoreObjectGraph.props.enabled("paymentTopicFromBag") &&
                appStoreObjectGraph.bag.metricsPaymentNamespaceEnabled) {
                paymentMetricsIdentifiersCache = new MetricsIdentifiersCache(paymentIdentifierContextMapping);
                // Only add this promise if paymentMetricsIdentifiersCache is actually created
                await paymentMetricsIdentifiersCache.loadValues(appStoreObjectGraph, [
                    MetricsIdentifierType.client,
                    MetricsIdentifierType.user,
                ]);
            }
            objectGraph = appStoreObjectGraph;
        }
        return objectGraph
            .adding(ExperimentCache.metatype, experimentCache)
            .adding(MetricsIdentifiersCache.defaultMetatype, metricsIdentifiersCache)
            .adding(MetricsIdentifiersCache.paymentMetatype, paymentMetricsIdentifiersCache || metricsIdentifiersCache)
            .adding(MetricsIdentifiersCache.personalizationMetatype, personalizationMetricsIdentifierCache);
    }
}
//# sourceMappingURL=app-store-intent-dispatcher.js.map