/**
 * Created by keithpk on 12/3/16.
 */
/**
 * The `FormBuilder` class can be used to construct HTTP
 * the form parameters for use with an HTTP post operation.
 */
export class FormBuilder {
    /**
     * The content type to use for form parameters.
     */
    static get contentType() {
        return "application/x-www-form-urlencoded";
    }
    /**
     * Construct an empty form builder.
     */
    constructor() {
        this._params = "";
    }
    /**
     *  Append a parameter to the builder's form parameters.
     *  @param  key   The key of the parameter.
     *  @param  value The value of the parameter.
     *  @return The builder.
     */
    param(key, value) {
        if (key && value) {
            const separator = this._params.length > 0 ? "&" : "";
            this._params += `${separator}${encodeURIComponent(key)}=${encodeURIComponent(value)}`;
        }
        return this;
    }
    /**
     *  Create and return a form parameters string based on the contents of the builder.
     *  @return The form parameters string.
     */
    build() {
        return this._params;
    }
}
//# sourceMappingURL=http.js.map