import * as serverData from "../json-parsing/server-data";
export function hasRelationship(data, relationshipType, checkForContent = true) {
    const relationshipDataContainer = relationship(data, relationshipType);
    if (!relationshipDataContainer) {
        return false;
    }
    if (!relationshipDataContainer.data || (checkForContent && relationshipDataContainer.data.length === 0)) {
        return false;
    }
    return true;
}
export function relationship(data, relationshipType) {
    if (serverData.isDefinedNonNull(data)) {
        return serverData.asInterface(data.relationships, relationshipType);
    }
    return null;
}
export function relationshipViewsContainer(data, relationshipType) {
    return serverData.asInterface(data.views, relationshipType);
}
export function relationshipData(objectGraph, data, relationshipType) {
    const relationshipDataArray = serverData.asArrayOrEmpty(data.relationships, [
        relationshipType,
        "data",
    ]);
    if (relationshipDataArray.length === 0) {
        return null;
    }
    if (relationshipDataArray.length > 1) {
        objectGraph.console.warn(`there was an array of relationships when only the first was asked for in relationship ${relationshipType}`);
    }
    return relationshipDataArray[0];
}
export function relationshipCollection(data, relationshipType, allowNulls = false) {
    if (!hasRelationship(data, relationshipType, false) && allowNulls) {
        return null;
    }
    return serverData.asArrayOrEmpty(data.relationships, [relationshipType, "data"]);
}
export function relationshipViewsCollection(data, relationshipType) {
    return serverData.asArrayOrEmpty(data.views, [relationshipType, "data"]);
}
//# sourceMappingURL=relationships.js.map