import { makeMetatype } from "@jet/environment/util/metatype";
import { ExperimentAreaId } from "./experiment-area-id";
export class ExperimentCache {
    constructor() {
        this.cachedTreatments = {};
        this.cachedRawTreatments = {};
    }
    async loadTreatments(objectGraph) {
        const experimentAreas = this.experimentAreasForPlatform(objectGraph);
        if (experimentAreas.length > 0) {
            try {
                this.cachedRawTreatments = await objectGraph.treatmentStore.treatmentsForAreas(experimentAreas);
                for (const [experimentAreaId, treatment] of Object.entries(this.cachedRawTreatments)) {
                    /// AMS Adds some debug metadata after the treatment identifier in internal builds we do not want this
                    /// for app store usage
                    const rawIdentifier = treatment.identifier;
                    this.cachedTreatments[experimentAreaId] = {
                        ...treatment,
                        identifier: rawIdentifier.split(":")[0],
                    };
                }
            }
            catch (error) {
                objectGraph.console.error("Failed to load treatments", error);
            }
        }
    }
    currentTreatmentForExperiment(experimentAreaId) {
        return this.cachedTreatments[experimentAreaId];
    }
    createAb2Data() {
        const ab2Data = [];
        for (const [experimentAreaId, treatment] of Object.entries(this.cachedRawTreatments)) {
            ab2Data.push({
                areaId: experimentAreaId,
                bucket: -2,
                treatmentId: treatment.identifier,
            });
        }
        return ab2Data;
    }
    experimentAreasForPlatform(objectGraph) {
        const experimentAreas = [];
        switch (objectGraph.client.deviceType) {
            case "phone":
            case "pad":
                experimentAreas.push(...[
                    ExperimentAreaId.ArcadeDownloadPackOnboarding,
                    ExperimentAreaId.CondensedTodayAds,
                    ExperimentAreaId.ProductPagePreloading,
                    ExperimentAreaId.ProductPageVariants,
                    ExperimentAreaId.ProductPageYMALRowCount,
                    ExperimentAreaId.SearchLandingPage,
                ]);
                break;
            default:
                break;
        }
        return experimentAreas;
    }
}
ExperimentCache.metatype = makeMetatype("app-store:experimentCache");
//# sourceMappingURL=experiment-cache.js.map