export class LocaleFromBag {
    constructor(objectGraph) {
        this.objectGraph = objectGraph;
    }
    /**
     * The current {@link NormalizedStorefront | storefront} for the client
     *
     * This reads directly from the `Bag`, as that is the source of truth
     * for locale information in the "native" clients
     */
    get activeStorefront() {
        // The type-cast here reflects the implicit assumption that any values
        // belonging to the `Bag` have already been normalized
        return this.objectGraph.bag.mediaCountryCode;
    }
    /**
     * The current {@link NormalizedLanguage | language} for the client
     *
     * This reads directly from the `Bag`, as that is the source of truth
     * for locale information in the "native" clients
     */
    get activeLanguage() {
        // The type-cast here reflects the implicit assumption that any values
        // belonging to the `Bag` have already been normalized
        return this.objectGraph.bag.language;
    }
    setActiveLocale(_locale) {
        // Intentional no-op; "native" clients that use the `Bag` as the source
        // of "locale" information do not allow for mutation of the "locale"
    }
    normalize(_unnormalizedLocale) {
        return {
            storefront: this.activeStorefront,
            language: this.activeLanguage,
        };
    }
    deriveLocaleForUrl(locale) {
        return locale;
    }
}
//# sourceMappingURL=locale-from-bag.js.map