import { isSome } from "@jet/environment/types/optional";
import { dataCollectionFromDataContainer } from "../../foundation/media/data-structure";
import { withActiveIntent } from "../../foundation/dependencies/active-intent";
import { asDictionary, isDefinedNonNullNonEmpty } from "../../foundation/json-parsing/server-data";
import { attributeAsDictionary } from "../../foundation/media/attributes";
import { Request } from "../../foundation/media/data-fetching";
import { fetchData } from "../../foundation/media/network";
import { relationshipData } from "../../foundation/media/relationships";
import { artworkFromApiArtwork } from "../../common/content/content";
import { actionFromData } from "../../common/lockups/lockups";
import { newLocationTracker } from "../../common/metrics/helpers/location";
export class CategoryTabsIntentController {
    constructor() {
        this.$intentKind = "CategoryTabsIntent";
    }
    async perform(intent, objectGraphWithoutActiveIntent) {
        return await withActiveIntent(objectGraphWithoutActiveIntent, intent, async (objectGraph) => {
            const editorialItemId = objectGraph.bag.webNavigationCategoryTabsEditorialItemId;
            if (!isSome(editorialItemId)) {
                return [];
            }
            const attributes = ["editorialArtwork"];
            const request = new Request(objectGraph)
                .withIdOfType(editorialItemId, "collections")
                .includingScopedAttributes("editorial-items", attributes)
                .includingScopedAttributes("editorial-pages", attributes)
                .addingQuery("sparseLimit[card-contents]", "0")
                .addingQuery("platform", "web")
                .addingQuery("previewPlatform", objectGraph.activeIntent.platform);
            const response = await fetchData(objectGraph, request);
            const contents = dataCollectionFromDataContainer(response);
            return contents.map((item) => {
                const primaryContent = relationshipData(objectGraph, item, "primary-content");
                const dataSource = primaryContent || item;
                const metricsBase = {
                    pageInformation: null,
                    locationTracker: newLocationTracker(),
                    id: item.id,
                };
                const formattedArtwork = getFormattedArtwork(objectGraph, item);
                return {
                    action: actionFromData(objectGraph, dataSource, metricsBase, objectGraph.host.clientIdentifier),
                    isActive: intent.id === dataSource.id,
                    artwork: formattedArtwork,
                };
            });
        });
    }
}
function getFormattedArtwork(objectGraph, data) {
    const artwork = attributeAsDictionary(data, "artwork", null) || attributeAsDictionary(data, "editorialArtwork");
    if (!isDefinedNonNullNonEmpty(artwork)) {
        return undefined;
    }
    const editorialArtwork = attributeAsDictionary(data, "editorialArtwork");
    const icon = asDictionary(editorialArtwork, "brandLogo", null);
    return artworkFromApiArtwork(objectGraph, icon, {
        allowingTransparency: true,
        useCase: 20 /* ArtworkUseCase.CategoryIcon */,
    });
}
//# sourceMappingURL=category-tabs-intent-controller.js.map