import { makeChartsPageIntent } from "../../api/intents/charts-page-intent";
import { withActiveIntent } from "../../foundation/dependencies/active-intent";
import { renderChartsHub } from "../../common/charts/charts-hub";
import { chartsHubPageRoutes, makeChartsHubPageURL } from "../../common/charts/charts-page-url";
import { injectWebNavigation } from "../../common/web-navigation/inject-web-navigation";
import { injectSEOData } from "../../api/models/web-renderable-page";
const APPS_GENRE_ID_STATIC = "36";
const GAMES_GENRE_ID_STATIC = "6014";
export const ChartsHubPageIntentController = {
    $intentKind: "ChartsHubPageIntent",
    routes: chartsHubPageRoutes,
    async perform(intent, objectGraphWithoutActiveIntent) {
        return await withActiveIntent(objectGraphWithoutActiveIntent, intent, async (objectGraph) => {
            var _a;
            const [appsPage, gamesPage] = await Promise.all([
                objectGraph.dispatcher.dispatch(makeChartsPageIntent({
                    storefront: intent.storefront,
                    language: intent.language,
                    platform: intent.platform,
                    genreId: APPS_GENRE_ID_STATIC,
                }), objectGraph),
                objectGraph.dispatcher.dispatch(makeChartsPageIntent({
                    storefront: intent.storefront,
                    language: intent.language,
                    platform: intent.platform,
                    genreId: GAMES_GENRE_ID_STATIC,
                }), objectGraph),
            ]);
            const hubPage = renderChartsHub(objectGraph, appsPage, gamesPage);
            hubPage.canonicalURL = makeChartsHubPageURL(objectGraph, intent);
            if (objectGraph.client.isWeb) {
                injectWebNavigation(objectGraph, hubPage, intent.platform);
                injectSEOData(hubPage, (_a = objectGraph.seo) === null || _a === void 0 ? void 0 : _a.getSEODataForChartsHubPage(objectGraph, hubPage, null));
            }
            return hubPage;
        });
    },
};
//# sourceMappingURL=charts-hub-page-intent-controller.js.map