import { withActiveIntent } from "../../foundation/dependencies/active-intent";
import { buildTodayPageFromRequest, generateTodayPageRequest, prepareRequest as prepareTodayPageRequest, } from "../../common/today/today-controller-util";
import { injectWebNavigation } from "../../common/web-navigation/inject-web-navigation";
import { injectSEOData } from "../../api/models/web-renderable-page";
export const RoutableTodayPageIntentController = {
    $intentKind: "RoutableTodayPageIntent",
    async perform(intent, objectGraphWithoutActiveIntent) {
        return await withActiveIntent(objectGraphWithoutActiveIntent, intent, async (objectGraph) => {
            var _a;
            const mediaApiRequest = generateTodayPageRequest(objectGraph);
            prepareTodayPageRequest(objectGraph, mediaApiRequest, true);
            const page = await buildTodayPageFromRequest(objectGraph, mediaApiRequest);
            if (objectGraph.client.isWeb) {
                injectWebNavigation(objectGraph, page, intent.platform);
                injectSEOData(page, (_a = objectGraph.seo) === null || _a === void 0 ? void 0 : _a.getSEODataForTodayPage(objectGraph, page, null));
            }
            return page;
        });
    },
};
//# sourceMappingURL=routable-today-page-intent-controller.js.map