import { withActiveIntent } from "../../foundation/dependencies/active-intent";
import { isNothing } from "@jet/environment";
import * as mediaNetwork from "../../foundation/media/network";
import * as mediaDataFetching from "../../foundation/media/data-fetching";
import * as models from "../../api/models";
import * as serverData from "../../foundation/json-parsing/server-data";
export const EulaPageIntentController = {
    $intentKind: "EulaPageIntent",
    async perform(intent, objectGraphWithoutActiveIntent) {
        return await withActiveIntent(objectGraphWithoutActiveIntent, intent, async (objectGraph) => {
            const { resourceId, resourceType } = intent;
            if (isNothing(resourceId) || isNothing(resourceType)) {
                const notFoundError = new mediaNetwork.NetworkError("content not found");
                notFoundError.statusCode = 404;
                throw notFoundError;
            }
            const mediaApiRequest = new mediaDataFetching.Request(objectGraph).withIdOfType(resourceId, "eula");
            mediaApiRequest.targetResourceType = resourceType;
            const response = await mediaNetwork.fetchData(objectGraph, mediaApiRequest);
            const fullText = serverData.asString(response, "results.eula.text");
            const textParagraphs = fullText.split(/\n{1,2}/); // Split by one or two newlines. 3+ are respected.
            const paragraphs = [];
            for (const text of textParagraphs) {
                const paragraph = new models.Paragraph(text);
                paragraph.wantsCollapsedNewlines = false;
                paragraph.suppressVerticalMargins = true;
                paragraphs.push(paragraph);
            }
            const shelf = new models.Shelf("paragraph");
            shelf.isHorizontal = false;
            shelf.items = paragraphs;
            const page = new models.GenericPage([shelf]);
            page.title = objectGraph.loc.string("LICENSE_AGREEMENT");
            return page;
        });
    },
};
//# sourceMappingURL=eula-page-intent-controller.js.map