import { isNothing } from "@jet/environment/types/optional";
import * as mediaNetwork from "../../foundation/media/network";
import { withActiveIntent } from "../../foundation/dependencies/active-intent";
import { editorialShelfCollectionPageRoutes, makeEditorialShelfCollectionPageURL, makeEditorialShelfCollectionPageRequest, renderEditorialShelfCollectionPage, } from "../../common/editorial-pages/editorial-shelf-collection-page-utils";
import { injectWebNavigation } from "../../common/web-navigation/inject-web-navigation";
import { injectSEOData } from "../../api/models/web-renderable-page";
import { validateEditorialShelfCollectionId } from "../../foundation/media/util";
export const EditorialShelfCollectionPageIntentController = {
    $intentKind: "EditorialShelfCollectionPageIntent",
    routes: editorialShelfCollectionPageRoutes,
    async perform(intent, objectGraphWithoutActiveIntent) {
        return await withActiveIntent(objectGraphWithoutActiveIntent, intent, async (objectGraph) => {
            var _a;
            // See: https://github.pie.apple.com/its/amp-enums/blob/f75500b44f871f35ba3ce459a5ff4c9f225e71b0/src/main/java/com/apple/jingle/store/IdSpace.java#L43
            validateEditorialShelfCollectionId(objectGraph, intent.id);
            const mediaApiReqest = makeEditorialShelfCollectionPageRequest(objectGraph, intent);
            const response = await mediaNetwork.fetchData(objectGraph, mediaApiReqest);
            const editorialShelfCollectionPage = renderEditorialShelfCollectionPage(objectGraph, response);
            if (isNothing(editorialShelfCollectionPage)) {
                const notFoundError = new mediaNetwork.NetworkError("Media API response lacked required data");
                notFoundError.statusCode = 404;
                throw notFoundError;
            }
            if (isNothing(editorialShelfCollectionPage.canonicalURL)) {
                editorialShelfCollectionPage.canonicalURL = makeEditorialShelfCollectionPageURL(objectGraph, intent);
            }
            if (objectGraph.client.isWeb) {
                injectWebNavigation(objectGraph, editorialShelfCollectionPage, intent.platform);
                injectSEOData(editorialShelfCollectionPage, (_a = objectGraph.seo) === null || _a === void 0 ? void 0 : _a.getSEODataForEditorialShelfCollectionPage(objectGraph, editorialShelfCollectionPage, response));
            }
            return editorialShelfCollectionPage;
        });
    },
};
//# sourceMappingURL=editorial-shelf-collection-page-intent-controller.js.map