import { ArcadeSeeAllGamesPage } from "../../api/models";
import { defaultAdditionalPlatformsForClient } from "../../foundation/media/data-fetching";
import { fetchData } from "../../foundation/media/network";
import { withActiveIntent } from "../../foundation/dependencies/active-intent";
import { arcadeAppsRequest } from "../../common/arcade/arcade-common";
import { defaultRequestAttributes, prepareRequestWithSelectedFacets } from "../../common/arcade/arcade-see-all-request";
import { createArcadeSeeAllGamesPaginationToken, createShelves, } from "../../common/arcade/render-arcade-see-all-games-page";
import { shouldFetchCustomAttributes } from "../../common/product-page/product-page-variants";
import { metricsPageInformationFromMediaApiResponse } from "../../common/metrics/helpers/page";
import { asArrayOrEmpty } from "../../foundation/json-parsing/server-data";
import { injectWebNavigation } from "../../common/web-navigation/inject-web-navigation";
import { createDefaultSelectedFacetOptions } from "../../common/arcade/arcade-see-all-games-facets";
import { arcadeSeeAllRoutes as routes, makeArcadeSeeAllCanonicalUrl } from "../../common/arcade/arcade-see-all-routing";
import { injectSEOData } from "../../api/models/web-renderable-page";
export const RoutableArcadeSeeAllPageController = {
    $intentKind: "RoutableArcadeSeeAllPageIntent",
    routes,
    async perform(intent, objectGraphWithoutActiveIntent) {
        return await withActiveIntent(objectGraphWithoutActiveIntent, intent, async (objectGraph) => {
            var _a;
            const mediaApiRequest = arcadeAppsRequest(objectGraph)
                .includingAdditionalPlatforms(defaultAdditionalPlatformsForClient(objectGraph))
                .includingAttributes(defaultRequestAttributes(objectGraph))
                .usingCustomAttributes(shouldFetchCustomAttributes(objectGraph));
            if (objectGraph.client.isWeb) {
                mediaApiRequest.withSparseLimit(20);
            }
            prepareRequestWithSelectedFacets(mediaApiRequest, createDefaultSelectedFacetOptions(objectGraph));
            const mediaApiResponse = await fetchData(objectGraph, mediaApiRequest);
            const pageInformation = metricsPageInformationFromMediaApiResponse(objectGraph, "Room", "arcadeSeeAllGames", mediaApiResponse);
            const paginationToken = createArcadeSeeAllGamesPaginationToken(objectGraph, { isCompactMode: false }, pageInformation);
            const page = new ArcadeSeeAllGamesPage(createShelves(objectGraph, asArrayOrEmpty(mediaApiResponse, "results.groups"), paginationToken));
            if (objectGraph.client.isWeb) {
                page.canonicalURL = makeArcadeSeeAllCanonicalUrl(objectGraph, intent);
                injectWebNavigation(objectGraph, page, intent.platform);
                injectSEOData(page, (_a = objectGraph.seo) === null || _a === void 0 ? void 0 : _a.getSEODataForArcadeSeeAllPage(objectGraph, page, mediaApiResponse));
            }
            return page;
        });
    },
};
//# sourceMappingURL=routable-arcade-see-all-page-controller.js.map