import { isNothing } from "@jet/environment/types/optional";
import { fetchData } from "../../foundation/media/network";
import { makeBaseGroupingPageRequest, prepareGroupingPageRequest } from "../../common/grouping/grouping-request";
import { flattenedGroupingFromDataContainer, groupingPageFromFlattenedGrouping, groupingParseContextFromDataContainer, } from "../../common/grouping/render-grouping-page";
import { arcadeAppsRequestForIcons } from "../../common/arcade/arcade-common";
import { GroupingArcadeFooterShelfController } from "../../common/grouping/shelf-controllers/grouping-arcade-footer-shelf-controller";
import { injectWebNavigation } from "../../common/web-navigation/inject-web-navigation";
import { injectSEOData } from "../../api/models/web-renderable-page";
import { withActiveIntent } from "../../foundation/dependencies/active-intent";
import { setPreviewPlatform } from "../../common/preview-platform";
function makeMediaApiArcadeGroupingPageRequest(objectGraph, intent) {
    const mediaApiRequest = makeBaseGroupingPageRequest(objectGraph)
        .addingQuery("name", "arcade")
        .addingQuery("tabs", "subscriber");
    prepareGroupingPageRequest(objectGraph, mediaApiRequest);
    setPreviewPlatform(objectGraph, mediaApiRequest);
    return mediaApiRequest;
}
function makeArcadeSeeAllShelf(objectGraph, groupingParseContext, response) {
    const token = {
        id: "arcade-see-all-games-footer",
        presentationHints: {},
        featuredContentId: -1 /* FeaturedContentID.Native_GroupingShelf */,
        featuredContentData: null,
        nativeGroupingShelfId: 1 /* NativeGroupingShelfID.Arcade_SeeAllGamesFooter */,
        metricsPageInformation: groupingParseContext.metricsPageInformation,
        metricsLocationTracker: groupingParseContext.metricsLocationTracker,
        pageGenreId: groupingParseContext.pageGenreId,
        title: null,
        shouldFilter: false,
        remainingItems: [],
        isFirstRender: true,
        isDeferring: false,
        showOrdinals: false,
        hasExistingContent: false,
        showingPlaceholders: false,
        ordinalIndex: 1,
        isSearchLandingPage: groupingParseContext.isSearchLandingPage,
        isArcadePage: groupingParseContext === null || groupingParseContext === void 0 ? void 0 : groupingParseContext.isArcadePage,
    };
    const groupingArcadeFooterShelfController = new GroupingArcadeFooterShelfController();
    const arcadeFooterShelf = groupingArcadeFooterShelfController.createShelf(objectGraph, response, groupingParseContext, token, null);
    return arcadeFooterShelf;
}
export const ArcadeGroupingPageIntentController = {
    $intentKind: "ArcadeGroupingPageIntent",
    async perform(intent, objectGraphWithoutActiveIntent) {
        return await withActiveIntent(objectGraphWithoutActiveIntent, intent, async (objectGraph) => {
            var _a;
            const groupingPageRequest = makeMediaApiArcadeGroupingPageRequest(objectGraph, intent);
            const arcadeFooterRequest = arcadeAppsRequestForIcons(objectGraph, 20);
            const [groupingPageResponse, arcadeFooterResponse] = await Promise.all([
                fetchData(objectGraph, groupingPageRequest),
                fetchData(objectGraph, arcadeFooterRequest),
            ]);
            const flattenedGrouping = flattenedGroupingFromDataContainer(objectGraph, groupingPageResponse);
            const groupingParseContext = groupingParseContextFromDataContainer(objectGraph, groupingPageResponse);
            if (isNothing(flattenedGrouping) || isNothing(groupingParseContext)) {
                return null;
            }
            const page = groupingPageFromFlattenedGrouping(objectGraph, flattenedGrouping, groupingParseContext);
            page.shelves.push(makeArcadeSeeAllShelf(objectGraph, groupingParseContext, arcadeFooterResponse));
            if (objectGraph.client.isWeb) {
                injectWebNavigation(objectGraph, page, intent.platform);
                injectSEOData(page, (_a = objectGraph.seo) === null || _a === void 0 ? void 0 : _a.getSEODataForGroupingPage(objectGraph, page, groupingPageResponse));
            }
            return page;
        });
    },
};
//# sourceMappingURL=arcade-grouping-page-intent-controller.js.map