import { createWebNavigation, setActivePlatform } from "./web-navigation";
/**
 * The "default" {@linkcode PreviewPlatform} that should be used for the navigation state in cases
 * where an explicit value is not provided
 */
const FALLBACK_PREVIEW_PLATFORM = "iphone";
/**
 * Inject the `WebNavigation` into a page model
 *
 * @param objectGraph
 * @param page the page to inject the navigation into
 * @param platform the `PreviewPlatform` to render navigation links for
 * @returns the web navigation shelf, in case further mutation is required
 */
export function injectWebNavigation(objectGraph, page, platform) {
    const webNavigation = createWebNavigation(objectGraph, platform !== null && platform !== void 0 ? platform : FALLBACK_PREVIEW_PLATFORM);
    if (page.title) {
        webNavigation.title = page.title;
    }
    page.webNavigation = webNavigation;
    return webNavigation;
}
/**
 * Sets the `WebNavigation` contained by {@linkcode page} to reflect {@linkcode platform}
 * as the active platform. Landing pages links will also be made active based on {@linkcode intent}
 */
export function updateWebNavigation(objectGraph, page, platform, intent) {
    if (page.webNavigation) {
        setActivePlatform(objectGraph, page.webNavigation, platform, intent);
    }
}
//# sourceMappingURL=inject-web-navigation.js.map