/**
 * Created by ls on 6/19/2019.
 */
/**
 * On different platforms, different shelves are expected to be in certain multiples to not appear like there is a "gap"
 * This function is used to truncate an array of models to fit given expected multiple.
 * Note that ideally we want to request the exact number of items needed, but this accounts for cases where some data fails to build into full UI elements.
 * @param items Array of items to truncate
 * @param mod Modulo to apply.
 */
export function truncateItems(items, mod) {
    if (!items) {
        return null;
    }
    const length = items.length;
    const remainder = length % mod;
    // If we have less than mod items, we should return them all instead of 0 (because i - (i % mod)=0 when i < mod)
    if (length >= mod) {
        return items.slice(0, length - remainder);
    }
    else {
        return items;
    }
}
//# sourceMappingURL=page-common.js.map