import * as models from "../../api/models";
import * as metricsHelpersLocation from "../metrics/helpers/location";
/**
 * Stateful container passed along pipeline from initial page building, mutating while components are being built.
 * Properties on this *can* be snapshotted to re-initialize a context for shelf-reloading and pagination.
 */
export class TodayParseContext {
    constructor(pageInformation, locationTracker, refreshController) {
        // The location tracker for building metrics location information
        this.locationTracker = metricsHelpersLocation.newLocationTracker();
        /// The number of cards that we've successfully parsed, This excludes failed cards
        this.parsedCardCount = 0;
        /// The number of rows of cards that we've successfully added to the page. This is only applicable on
        /// iPhone where we know there is only one layout per page. This differs from parsedCardCount in that
        /// rows can contain multiple cards, such is the case with hero / grid shelves.
        this.currentRowIndex = 0;
        this.pageInformation = pageInformation;
        this.locationTracker = locationTracker !== null && locationTracker !== void 0 ? locationTracker : metricsHelpersLocation.newLocationTracker();
        this.refreshController = refreshController;
    }
}
/**
 * The `TodayPageContext` is used for building the initial page. It is used to maintain a record
 * of the remaining items left in the today page, so it is also used for pagination
 */
export class TodayPageContext extends TodayParseContext {
    constructor(remainingContent, pageInformation, locationTracker, refreshController, recoImpressionData) {
        super(pageInformation, locationTracker, refreshController);
        // Flag indicating whether we've ever successfully displayed any content on the page, if we're
        // doing a secondary fetch and this is false, we try to fetch a bit more than normal pagination
        // to have a higher chance of getting **some** content back.
        this.pageHasDisplayedContent = false;
        this.remainingContent = remainingContent;
        this.adPlacementBehavior = models.AdPlacementBehavior.insertIntoShelf;
        this.recoImpressionData = recoImpressionData;
    }
}
/**
 * A `TodayShelfToken` is used to maintain a record of each shelf's contents when subsequent content fetch is needed. It is encoded in the `url` property of `Shelf`.
 */
export class TodayShelfToken {
    // endregion
    constructor(todayModule, contentOffsetWithinModule, metricsPageInformation, metricsLocationTracker) {
        this.todayModule = todayModule;
        this.metricsPageInformation = metricsPageInformation;
        this.contentOffsetWithinModule = contentOffsetWithinModule;
        this.metricsLocationTracker = metricsLocationTracker;
    }
}
/**
 * These are the different ways we can display a today card
 */
export var TodayCardDisplayStyle;
(function (TodayCardDisplayStyle) {
    TodayCardDisplayStyle["AppEventCard"] = "AppEventCard";
    TodayCardDisplayStyle["AppOfTheDay"] = "AppOfTheDay";
    TodayCardDisplayStyle["FullBleedImage"] = "FullBleedImage";
    TodayCardDisplayStyle["GameOfTheDay"] = "GameOfTheDay";
    TodayCardDisplayStyle["Grid"] = "Grid";
    TodayCardDisplayStyle["InAppPurchase"] = "InAppPurchase";
    TodayCardDisplayStyle["List"] = "List";
    TodayCardDisplayStyle["NumberedList"] = "NumberedList";
    TodayCardDisplayStyle["River"] = "River";
    TodayCardDisplayStyle["ShortImage"] = "ShortImage";
    TodayCardDisplayStyle["SingleApp"] = "SingleApp";
    TodayCardDisplayStyle["Video"] = "Video";
})(TodayCardDisplayStyle || (TodayCardDisplayStyle = {}));
/**
 * These are the different sizes of today card we can have,
 * the reason this uses the term `DisplayStyle` is because the the metrics spec
 * already uses the term `DisplayStyle` to describe the size of different components
 * so we're reusing that term here. This is not to be confused with `TodayCardDisplayStyle`
 */
export var TodayCardMetricsDisplayStyle;
(function (TodayCardMetricsDisplayStyle) {
    TodayCardMetricsDisplayStyle["SmallCard"] = "smallCard";
    TodayCardMetricsDisplayStyle["MediumCard"] = "mediumCard";
})(TodayCardMetricsDisplayStyle || (TodayCardMetricsDisplayStyle = {}));
/**
 * These are the different ways we can display artwork within a today section header
 */
export var TodayHeaderArtworkBehavior;
(function (TodayHeaderArtworkBehavior) {
    TodayHeaderArtworkBehavior["NoArtwork"] = "no-artwork";
    TodayHeaderArtworkBehavior["ContentArtworkWithTitle"] = "content-artwork-with-title";
    TodayHeaderArtworkBehavior["CategoryArtworkWithTitle"] = "category-artwork-with-title";
    TodayHeaderArtworkBehavior["CategoryArtworkWithBadge"] = "category-artwork-with-badge";
})(TodayHeaderArtworkBehavior || (TodayHeaderArtworkBehavior = {}));
/**
 * The different types of today card OTD intentions
 */
export var OfTheDayIntention;
(function (OfTheDayIntention) {
    OfTheDayIntention["AppOfTheDay"] = "app-of-the-day";
    OfTheDayIntention["GameOfTheDay"] = "game-of-the-day";
})(OfTheDayIntention || (OfTheDayIntention = {}));
/**
 * Indicates the different places we can have artwork in the section header
 */
export var TodaySectionHeaderArtworkPlacement;
(function (TodaySectionHeaderArtworkPlacement) {
    TodaySectionHeaderArtworkPlacement["Eyebrow"] = "eyebrow";
    TodaySectionHeaderArtworkPlacement["Title"] = "title";
})(TodaySectionHeaderArtworkPlacement || (TodaySectionHeaderArtworkPlacement = {}));
export var EditorialBackgroundType;
(function (EditorialBackgroundType) {
    EditorialBackgroundType["LinearGradient"] = "linear-gradient";
})(EditorialBackgroundType || (EditorialBackgroundType = {}));
/**
 * Describes the context in which hero media appears. Used to
 * configure cards differently on macOS depending on where it appears.
 */
export var HeroMediaDisplayContext;
(function (HeroMediaDisplayContext) {
    HeroMediaDisplayContext["Inline"] = "inline";
    HeroMediaDisplayContext["Article"] = "article";
})(HeroMediaDisplayContext || (HeroMediaDisplayContext = {}));
//# sourceMappingURL=today-types.js.map