/**
 * Created by ls on 6/23/17.
 */
import * as serverData from "../../foundation/json-parsing/server-data";
const isOnboardingCardKey = "isOnBoardingCard";
/**
 * Tag a data collection as onboarding cards for metrics.
 * @param cardsData
 */
export function markDataCollectionAsOnboardingCards(objectGraph, cardsData) {
    for (const card of cardsData) {
        card[isOnboardingCardKey] = true;
    }
}
/**
 * Check whether given data was injected as onboarding card.
 * @param cardData Media API data for single card.
 * @returns A boolean returning `true` if `cardData` was from `makeOnBoardingCardToken`, `false` otherwise.
 */
export function isCardDataOnboardingCard(objectGraph, cardData) {
    return serverData.asBooleanOrFalse(cardData, isOnboardingCardKey);
}
//# sourceMappingURL=onboarding-cards.js.map