import * as validation from "@jet/environment/json/validation";
import { deepLinkUrlFromData } from "../../linking/external-deep-link";
import { applyTodayCardOverridesForAcquisitionStoryIfNecessary, relatedContentOverlayFromData, } from "../today-card-overlay-util";
import { cardDisplayStyleFromData, lockupsForRelatedContent, offerStyleForTodayCard, popTodayCardLocation, pushTodayCardLocation, relatedCardContentsContentsFromData, } from "../today-card-util";
import { addArtworkMediaToBaseCard, createTodayBaseCard } from "./today-base-card-builder";
/**
 * Create TodayCard displaying a video
 *
 * @param objectGraph The dependency graph for the App Store
 * @param data The media api data to build the card from
 * @param cardConfig The configuration for the card
 * @param context The parse context for the over all today page
 * @param augmentingData that stores some additional responses that may be used to enhance the contents of `data`
 * @returns The newly created TodayCard, using the video media.
 */
export function createTodayVideoCard(objectGraph, data, cardConfig, context, augmentingData) {
    return validation.context("createTodayVideoCard", () => {
        const videoCard = createTodayBaseCard(objectGraph, data, cardConfig, context);
        addArtworkMediaToBaseCard(objectGraph, data, videoCard, cardConfig, context);
        pushTodayCardLocation(objectGraph, data, cardConfig, context);
        const offerStyle = offerStyleForTodayCard(objectGraph, videoCard.style);
        const relatedContent = relatedCardContentsContentsFromData(objectGraph, data);
        const relatedContentLockups = lockupsForRelatedContent(objectGraph, relatedContent, cardConfig, context.pageInformation, context.locationTracker, "todayCard", offerStyle, deepLinkUrlFromData(objectGraph, data));
        const overlay = relatedContentOverlayFromData(objectGraph, videoCard, cardConfig, data, relatedContentLockups);
        videoCard.overlay = overlay;
        // Special post-processing step for Acquisition story cards.
        // This is needed to splice in data not included in initial response.
        applyTodayCardOverridesForAcquisitionStoryIfNecessary(objectGraph, videoCard, cardConfig, cardDisplayStyleFromData(data, cardConfig.coercedCollectionTodayCardDisplayStyle), data, augmentingData, context);
        popTodayCardLocation(context);
        return videoCard;
    });
}
//# sourceMappingURL=today-video-card-builder.js.map