import * as validation from "@jet/environment/json/validation";
import { deepLinkUrlFromData } from "../../linking/external-deep-link";
import { applyTodayCardOverridesForAcquisitionStoryIfNecessary, relatedContentOverlayFromData, } from "../today-card-overlay-util";
import { cardDisplayStyleFromData, lockupsForRelatedContent, offerEnvironmentForTodayCard, offerStyleForTodayCard, popTodayCardLocation, pushTodayCardLocation, relatedCardContentsContentsFromData, } from "../today-card-util";
import { addArtworkMediaToBaseCard, createTodayBaseCard } from "./today-base-card-builder";
import { addSingleAppFallbackToCard } from "./today-single-app-card-builder";
/**
 * Create TodayCard displaying the full bleed image
 *
 * @param objectGraph The dependency graph for the App Store
 * @param data The media api data to build the card from
 * @param cardConfig The configuration for the card
 * @param context The parse context for the over all today page
 * @param augmentingData that stores some additional responses that may be used to enhance the contents of `data`
 * @returns The newly created TodayCard, using the full bleed image media.
 */
export function createTodayShortImageCard(objectGraph, data, cardConfig, context, augmentingData) {
    return validation.context("createTodayShortImageCard", () => {
        const shortImageCard = createTodayBaseCard(objectGraph, data, cardConfig, context);
        pushTodayCardLocation(objectGraph, data, cardConfig, context);
        const didAddArtworkToCard = addArtworkMediaToBaseCard(objectGraph, data, shortImageCard, cardConfig, context);
        let didAddSingleAppFallback = false;
        const relatedContent = relatedCardContentsContentsFromData(objectGraph, data);
        const offerStyle = offerStyleForTodayCard(objectGraph, shortImageCard.style);
        const relatedContentLockups = lockupsForRelatedContent(objectGraph, relatedContent, cardConfig, context.pageInformation, context.locationTracker, offerEnvironmentForTodayCard(shortImageCard.style), offerStyle, deepLinkUrlFromData(objectGraph, data));
        const overlay = relatedContentOverlayFromData(objectGraph, shortImageCard, cardConfig, data, relatedContentLockups);
        shortImageCard.overlay = overlay;
        if (!didAddArtworkToCard && relatedContent.length === 1) {
            didAddSingleAppFallback = addSingleAppFallbackToCard(objectGraph, data, shortImageCard, relatedContent, cardConfig, context);
        }
        if (!didAddArtworkToCard && !didAddSingleAppFallback) {
            popTodayCardLocation(context);
            return null;
        }
        // Special post-processing step for Acquisition story cards.
        // This is needed to splice in data not included in initial response.
        applyTodayCardOverridesForAcquisitionStoryIfNecessary(objectGraph, shortImageCard, cardConfig, cardDisplayStyleFromData(data, cardConfig.coercedCollectionTodayCardDisplayStyle), data, augmentingData, context);
        popTodayCardLocation(context);
        return shortImageCard;
    });
}
//# sourceMappingURL=today-short-image-card-builder.js.map