import * as validation from "@jet/environment/json/validation";
import { deepLinkUrlFromData } from "../../linking/external-deep-link";
import { applyTodayCardOverridesForAcquisitionStoryIfNecessary, relatedContentOverlayFromData, } from "../today-card-overlay-util";
import { cardDisplayStyleFromData, lockupsForRelatedContent, offerEnvironmentForTodayCard, offerStyleForTodayCard, popTodayCardLocation, pushTodayCardLocation, relatedCardContentsContentsFromData, } from "../today-card-util";
import { addArtworkMediaToBaseCard, createTodayBaseCard } from "./today-base-card-builder";
/**
 * Create TodayCard displaying the full bleed image
 *
 * @param objectGraph The dependency graph for the App Store
 * @param data The media api data to build the card from
 * @param cardConfig The configuration for the card
 * @param context The parse context for the over all today page
 * @param augmentingData that stores some additional responses that may be used to enhance the contents of `data`
 * @returns The newly created TodayCard, using the full bleed image media.
 */
export function createTodayFullBleedImageCard(objectGraph, data, cardConfig, context, augmentingData) {
    return validation.context("createTodayFullBleedImageCard", () => {
        const fullBleedImageCard = createTodayBaseCard(objectGraph, data, cardConfig, context);
        pushTodayCardLocation(objectGraph, data, cardConfig, context);
        const didAddArtworkToCard = addArtworkMediaToBaseCard(objectGraph, data, fullBleedImageCard, cardConfig, context);
        if (!didAddArtworkToCard) {
            popTodayCardLocation(context);
            return null;
        }
        const relatedContent = relatedCardContentsContentsFromData(objectGraph, data);
        const offerStyle = offerStyleForTodayCard(objectGraph, fullBleedImageCard.style);
        const relatedContentLockups = lockupsForRelatedContent(objectGraph, relatedContent, cardConfig, context.pageInformation, context.locationTracker, offerEnvironmentForTodayCard(fullBleedImageCard.style), offerStyle, deepLinkUrlFromData(objectGraph, data));
        const overlay = relatedContentOverlayFromData(objectGraph, fullBleedImageCard, cardConfig, data, relatedContentLockups);
        fullBleedImageCard.overlay = overlay;
        // Special post-processing step for Acquisition story cards.
        // This is needed to splice in data not included in initial response.
        applyTodayCardOverridesForAcquisitionStoryIfNecessary(objectGraph, fullBleedImageCard, cardConfig, cardDisplayStyleFromData(data, cardConfig.coercedCollectionTodayCardDisplayStyle), data, augmentingData, context);
        popTodayCardLocation(context);
        return fullBleedImageCard;
    });
}
//# sourceMappingURL=today-full-bleed-image-card-builder.js.map