import { isSome } from "@jet/environment";
import { dayCard } from "./day-card";
import { eventCard } from "./event-card";
import { generalCard } from "./general-card";
import { listCardMotion21x9 } from "./list-card-motion-21x9";
import { listCardStatic21x9 } from "./list-card-static-21x9";
import { mediaCard } from "./media-card";
import { storeFrontVideo } from "./store-front-video";
import { storeFrontVideo4x3 } from "./store-front-video-4x3";
import { storyCardMotion16x9 } from "./story-card-motion-16x9";
import { storyCardStatic16x9 } from "./story-card-static-16x9";
import { storyCenteredMotion16x9 } from "./story-centered-motion-16x9";
import { storyCenteredStatic16x9 } from "./story-centered-static-16x9";
import { storySearchStatic16x9 } from "./story-search-static-16x9";
import { universalAMotion16x9 } from "./universal-a-motion-16x9";
import { universalAStatic16x9 } from "./universal-a-static-16x9";
import { categoryDetailMotion16x9 } from "./category-detail-motion-16x9";
import { categoryDetailStatic16x9 } from "./category-detail-static-16x9";
/**
 * Hero position on iPad requires the new artwork flavor to be considered valid
 */
export function universalAConfigurations(objectGraph, isHeroPosition) {
    return isHeroPosition
        ? [universalAMotion16x9Configuration(objectGraph), universalAStatic16x9Configuration(objectGraph)]
        : [];
}
export function dayCardConfiguration(objectGraph) {
    return dayCard;
}
export function eventCardConfiguration(objectGraph) {
    return eventCard;
}
export function generalCardConfiguration(objectGraph, cropCodeOverrides) {
    return applyOverrides(generalCard, cropCodeOverrides);
}
export function listCardMotion21x9Configuration(objectGraph) {
    return listCardMotion21x9;
}
export function listCardStatic21x9Configuration(objectGraph) {
    return listCardStatic21x9;
}
export function mediaCardConfiguration(objectGraph, cropCodeOverrides) {
    return applyOverrides(mediaCard, cropCodeOverrides);
}
export function storeFrontVideoConfiguration(objectGraph) {
    return storeFrontVideo;
}
export function storeFrontVideo4x3Configuration(objectGraph) {
    return storeFrontVideo4x3;
}
export function storyCardMotion16x9Configuration(objectGraph) {
    return storyCardMotion16x9;
}
export function storyCardStatic16x9Configuration(objectGraph) {
    return storyCardStatic16x9;
}
export function storyCenteredMotion16x9Configuration(objectGraph) {
    return storyCenteredMotion16x9;
}
export function storyCenteredStatic16x9Configuration(objectGraph, cropCodeOverrides) {
    return applyOverrides(storyCenteredStatic16x9, cropCodeOverrides);
}
export function categoryDetailMotion16x9Configuration(objectGraph) {
    return categoryDetailMotion16x9;
}
export function categoryDetailStatic16x9Configuration(objectGraph, cropCodeOverrides) {
    return applyOverrides(categoryDetailStatic16x9, cropCodeOverrides);
}
export function storySearchStatic16x9Configuration(objectGraph) {
    return storySearchStatic16x9;
}
function universalAMotion16x9Configuration(objectGraph) {
    return universalAMotion16x9;
}
function universalAStatic16x9Configuration(objectGraph) {
    return universalAStatic16x9;
}
function applyOverrides(mediaConfiguration, cropCodeOverrides) {
    const updatedMediaConfiguration = { ...mediaConfiguration };
    if (isSome(cropCodeOverrides)) {
        updatedMediaConfiguration.crops = cropCodeOverrides;
    }
    return updatedMediaConfiguration;
}
//# sourceMappingURL=index.js.map