import { ArtworkContentMode, EdgeInsetsZero, TodayCardArtworkSizedLayoutMetricsPriority, } from "../../../../api/models";
const eventCardLayout_mini = {
    collapsedContentMode: ArtworkContentMode.bottomLeft,
    collapsedLayoutInsets: {
        top: 0,
        left: -8,
        bottom: 0,
        right: 0,
    },
    expandedContentMode: ArtworkContentMode.bottomLeft,
    expandedLayoutInsets: EdgeInsetsZero,
};
const eventCardLayout_base = {
    collapsedContentMode: ArtworkContentMode.bottomLeft,
    collapsedLayoutInsets: EdgeInsetsZero,
    expandedContentMode: ArtworkContentMode.bottomLeft,
    expandedLayoutInsets: EdgeInsetsZero,
};
const eventCardLayout_700w = {
    collapsedContentMode: ArtworkContentMode.scaleAspectFill,
    expandedContentMode: ArtworkContentMode.bottomLeft,
    collapsedLayoutInsets: EdgeInsetsZero,
    expandedLayoutInsets: EdgeInsetsZero,
};
const eventCardMetrics_mini = {
    maxWidth: 250,
    ltr: eventCardLayout_mini,
    rtl: eventCardLayout_mini,
    collapsedSize: { type: "fractionalHeight", height: 1.0 },
    priority: TodayCardArtworkSizedLayoutMetricsPriority.Mini,
};
const eventCardMetrics_base = {
    maxWidth: 704,
    ltr: eventCardLayout_base,
    rtl: eventCardLayout_base,
    collapsedSize: { type: "fractionalHeight", height: 1.062 },
};
const eventCardMetrics_700w = {
    ltr: eventCardLayout_700w,
    rtl: eventCardLayout_700w,
    collapsedSize: { type: "fractionalWidth", width: 1.0 },
};
export const eventCard = {
    objectPath: "editorialArtwork.eventCard",
    cardArtLayoutMetrics: [eventCardMetrics_mini, eventCardMetrics_base, eventCardMetrics_700w],
    crops: ["sr"],
    sourceWidth: 800,
    sourceHeight: 490,
    type: "image",
};
//# sourceMappingURL=event-card.js.map