import { FlowAction } from "../../api/models";
import { makeSearchResultsPageIntent, } from "../../api/intents/search-results-page-intent";
import { getLocale } from "../locale";
import { makeCanonicalSearchResultsPageUrl } from "./search-page-url";
/**
 * Creates a `FlowAction` destined for the search results page
 *
 * This will be used by the "web" client to perform search from the search landing page,
 * or to change the platform on search results page
 */
export function makeWebSearchAction(objectGraph, platform, term = "") {
    const searchAction = new FlowAction("search");
    const destination = makeSearchResultsPageIntent({
        ...getLocale(objectGraph),
        platform,
        term,
        origin: "externalUrl",
    });
    searchAction.destination = destination;
    searchAction.pageUrl = makeCanonicalSearchResultsPageUrl(objectGraph, destination);
    return searchAction;
}
//# sourceMappingURL=web-search-action.js.map