/**
 * Common operations for builders in search tab.
 */
// region Search Term State
/**
 * Build the `SearchTermContext` for a given response triggered by a search for `term`, possibly originating from `originatingTerm`
 * @param requestDescriptor The options that describe fetch request.
 * @param searchResponse The sequential response that was returned.
 */
export function createTermContextForSpellcheckedSequentialResponse(objectGraph, requestDescriptor, searchResponse) {
    var _a, _b, _c, _d, _e, _f, _g;
    return {
        term: requestDescriptor.term,
        suggestedTerm: (_b = (_a = searchResponse.results) === null || _a === void 0 ? void 0 : _a.spellCheck) === null || _b === void 0 ? void 0 : _b.suggestedTerm,
        correctedTerm: (_d = (_c = searchResponse.results) === null || _c === void 0 ? void 0 : _c.spellCheck) === null || _d === void 0 ? void 0 : _d.correctedTerm,
        resultsTerm: (_g = (_f = (_e = searchResponse.results) === null || _e === void 0 ? void 0 : _e.spellCheck) === null || _f === void 0 ? void 0 : _f.correctedTerm) !== null && _g !== void 0 ? _g : requestDescriptor.term,
        originatingTerm: requestDescriptor.originatingTerm,
    };
}
/**
 * Create a search term context for the segmented search results completed fetch
 * @param objectGraph The app store object graph
 * @param requestDescriptor The search request descriptor
 * @param searchResponse The response for the segmented search results page
 * @returns The search term context for the segmented search results fetch
 */
export function createTermContextForSpellcheckedGroupedResponse(objectGraph, requestDescriptor, searchResponse) {
    var _a, _b, _c, _d, _e, _f, _g;
    return {
        term: requestDescriptor.term,
        suggestedTerm: (_b = (_a = searchResponse.results) === null || _a === void 0 ? void 0 : _a.spellCheck) === null || _b === void 0 ? void 0 : _b.suggestedTerm,
        correctedTerm: (_d = (_c = searchResponse.results) === null || _c === void 0 ? void 0 : _c.spellCheck) === null || _d === void 0 ? void 0 : _d.correctedTerm,
        resultsTerm: (_g = (_f = (_e = searchResponse.results) === null || _e === void 0 ? void 0 : _e.spellCheck) === null || _f === void 0 ? void 0 : _f.correctedTerm) !== null && _g !== void 0 ? _g : requestDescriptor.term,
        originatingTerm: requestDescriptor.originatingTerm,
    };
}
/**
 * Build the `SearchTermContext` purely from `requestDescriptor` for requests that don't have spellchecking.
 * @param requestDescriptor The options that describe fetch request.
 */
export function createTermContextForNonspellcheckRequest(objectGraph, requestDescriptor) {
    return {
        term: requestDescriptor.term,
        resultsTerm: requestDescriptor.term,
        originatingTerm: requestDescriptor.originatingTerm,
    };
}
// endregion
// region Constants
/**
 * The field name desired within the `meta.metrics` in search response.
 */
export const searchMetricsDataSetID = "data.search.dataSetId";
/**
 * The actual field name within the `meta.metrics` in search response.
 */
export const legacySearchMetricsDataSetID = "dataSetId";
// endregion
//# sourceMappingURL=search-common.js.map