import { isNothing } from "@jet/environment";
import { MetadataRibbonItem } from "../../../api/models";
import * as mediaAttributes from "../../../foundation/media/attributes";
import * as metricsHelpersImpressions from "../../metrics/helpers/impressions";
export function createMetadataRibbonItems(objectGraph, data, lockup, dedupeSet, metricsOptions) {
    const tagData = data;
    const tagItem = new MetadataRibbonItem("textLabel");
    tagItem.moduleType = "tag";
    tagItem.labelText = mediaAttributes.attributeAsString(tagData, "name");
    if (isNothing(tagItem.labelText) || tagItem.labelText.length === 0 || dedupeSet.has(tagItem.labelText)) {
        return null;
    }
    const impressionOptions = metricsHelpersImpressions.impressionOptionsForMetadataRibbonItem(metricsOptions, tagData.id, tagItem.labelText, "tag_id");
    metricsHelpersImpressions.addImpressionFieldsToSearchMetadataRibbonItem(objectGraph, tagItem, impressionOptions);
    dedupeSet.add(tagItem.labelText);
    return [tagItem];
}
//# sourceMappingURL=tag-metadata-ribbon-item.js.map