import { MetadataRibbonItem } from "../../../api/models";
import { isNullOrEmpty } from "../../../foundation/json-parsing/server-data";
import { attributeAsArrayOrEmpty } from "../../../foundation/media/attributes";
import * as metricsHelpersImpressions from "../../metrics/helpers/impressions";
import * as metricsHelpersLocation from "../../metrics/helpers/location";
export function createMetadataRibbonItems(objectGraph, data, lockup, dedupeSet, metricsOptions) {
    const secondaryGenres = attributeAsArrayOrEmpty(data, "secondaryGenreShortDisplayNames");
    if (isNullOrEmpty(secondaryGenres)) {
        return null;
    }
    const secondaryCategoryItems = secondaryGenres.map((secondaryGenre) => {
        const categoryItem = new MetadataRibbonItem("textLabel");
        // Workaround for changing the moduleType to secondaryGenreShortDisplayNames from secondaryGenreShortDisplayName
        // otherwise native doesnt layout the secondary genres correctly
        // will be fixed with rdar://127458403 (Allow unknown metadataribbon items)
        categoryItem.moduleType = "genreShortDisplayName";
        categoryItem.labelText = secondaryGenre;
        const impressionOptions = metricsHelpersImpressions.impressionOptionsForMetadataRibbonItem(metricsOptions, "genreDisplayName", categoryItem.labelText, "static");
        metricsHelpersImpressions.addImpressionFieldsToSearchMetadataRibbonItem(objectGraph, categoryItem, impressionOptions);
        metricsHelpersLocation.nextPosition(metricsOptions.locationTracker);
        return categoryItem;
    });
    return secondaryCategoryItems.filter((category) => {
        return category.labelText != null && !dedupeSet.has(category.labelText);
    });
}
//# sourceMappingURL=secondary-short-categories-metadata-ribbon-item.js.map