import { isSome } from "@jet/environment";
import * as serverData from "../../../foundation/json-parsing/server-data";
import * as metricsHelpersLocation from "../../metrics/helpers/location";
import { standardList } from "./metadata-ribbon-item-factory";
import * as rankedSecondaryCategoryMetadataRibbonItem from "./ranked-secondary-category-metadata-ribbon-item";
export function createSearchTagsRibbonItemsForLockup(objectGraph, data, lockup, itemSlots, options, metadataRibbonItemFactory = standardList) {
    if (serverData.isNullOrEmpty(itemSlots)) {
        return [];
    }
    const tagData = serverData.asArrayOrEmpty(data.meta, "associations.tags.data");
    const metadataRibbonItems = [];
    // We need to keep track of how many tags we have so we can assign the tag properly
    let tagIndex = 0;
    let rankedSecondaryGenreIndex = 0;
    // We are going to pass in a set of strings for items we have already added to the ribbon so we never duplicate items
    const dedupeSet = new Set();
    for (const itemSlot of itemSlots) {
        const itemTypes = Array.isArray(itemSlot) ? itemSlot : [itemSlot];
        if (serverData.isNullOrEmpty(itemTypes)) {
            continue;
        }
        for (const itemType of itemTypes) {
            // If we find a tag, we pass in the tag data specifically
            // If we find a rankedSecondaryGenre, we want to call the factory function specifically.
            const isTag = itemType === "tag";
            const isRankedSecondaryGenre = itemType === "rankedSecondaryGenre";
            let results;
            let metadataItemData = data;
            let metadataItemString = "";
            if (isRankedSecondaryGenre) {
                const searchExperimentDataForLockup = serverData.asDictionary(data, "meta");
                if (isSome(searchExperimentDataForLockup === null || searchExperimentDataForLockup === void 0 ? void 0 : searchExperimentDataForLockup.rankedSecondaryGenreShortDisplayNames)) {
                    metadataItemString =
                        searchExperimentDataForLockup === null || searchExperimentDataForLockup === void 0 ? void 0 : searchExperimentDataForLockup.rankedSecondaryGenreShortDisplayNames[rankedSecondaryGenreIndex];
                }
                if (isSome(metadataItemString)) {
                    results =
                        rankedSecondaryCategoryMetadataRibbonItem.createMetadataRibbonItemsForRankedSecondaryCategory(objectGraph, metadataItemString, lockup, dedupeSet, options.metricsOptions);
                    rankedSecondaryGenreIndex = rankedSecondaryGenreIndex + 1;
                }
                else {
                    results = [];
                }
            }
            else {
                const metadataRibbonFactory = metadataRibbonItemFactory[itemType];
                if (serverData.isNull(metadataRibbonFactory)) {
                    continue;
                }
                if (isTag) {
                    metadataItemData = tagData[tagIndex];
                }
                else {
                    metadataItemData = data;
                }
                results = metadataRibbonFactory(objectGraph, metadataItemData, lockup, dedupeSet, options.metricsOptions);
                tagIndex = isTag ? tagIndex + 1 : tagIndex;
            }
            if (serverData.isDefinedNonNull(results)) {
                metadataRibbonItems.push(...results);
                for (const result of results) {
                    if (isSome(result.impressionMetrics)) {
                        metricsHelpersLocation.nextPosition(options.metricsOptions.locationTracker);
                    }
                }
                break;
            }
        }
    }
    return metadataRibbonItems;
}
//# sourceMappingURL=search-tags-ribbon.js.map