import { MetadataRibbonItem } from "../../../api/models";
import * as metricsHelpersImpressions from "../../metrics/helpers/impressions";
import { isNothing, isSome } from "@jet/environment";
/**
 * Creates a metadata ribbon item for ranked secondary category metadata ribbon type.
 * This particular function takes in the type string since we grab it from the data in the search-tags-ribbon.
 */
export function createMetadataRibbonItemsForRankedSecondaryCategory(objectGraph, data, lockup, dedupeSet, metricsOptions) {
    if (isNothing(data) || data.length === 0 || dedupeSet.has(data)) {
        return null;
    }
    const tagItem = new MetadataRibbonItem("textLabel");
    tagItem.moduleType = "rankedSecondaryGenre";
    if (isSome(data)) {
        tagItem.labelText = data;
        const impressionOptions = metricsHelpersImpressions.impressionOptionsForMetadataRibbonItem(metricsOptions, "rankedSecondaryGenre", tagItem.labelText, "static");
        metricsHelpersImpressions.addImpressionFieldsToSearchMetadataRibbonItem(objectGraph, tagItem, impressionOptions);
    }
    dedupeSet.add(data);
    return [tagItem];
}
//# sourceMappingURL=ranked-secondary-category-metadata-ribbon-item.js.map