import * as serverData from "../../../foundation/json-parsing/server-data";
import { standardList } from "./metadata-ribbon-item-factory";
export function createMetadataRibbonItemsForLockup(objectGraph, data, lockup, itemTypes, options, metadataRibbonItemFactory = standardList) {
    if (serverData.isNullOrEmpty(itemTypes)) {
        return [];
    }
    const metadataRibbonItems = [];
    const dedupeSet = new Set();
    for (const itemSlot of itemTypes) {
        if (serverData.isNullOrEmpty(itemSlot)) {
            continue;
        }
        for (const itemType of itemSlot) {
            const metadataRibbonFactory = metadataRibbonItemFactory[itemType];
            if (serverData.isNull(metadataRibbonFactory)) {
                continue;
            }
            const results = metadataRibbonFactory(objectGraph, data, lockup, dedupeSet, options.metricsOptions);
            if (serverData.isDefinedNonNull(results)) {
                metadataRibbonItems.push(...results);
                break;
            }
        }
    }
    return metadataRibbonItems;
}
//# sourceMappingURL=metadata-ribbon.js.map