import { isSome } from "@jet/environment/types/optional";
import * as models from "../../../api/models";
import * as metricsHelpersImpressions from "../../metrics/helpers/impressions";
export function createMetadataRibbonItems(objectGraph, data, lockup, dedupeSet, metricsOptions) {
    var _a;
    if (lockup.isEditorsChoice) {
        const editorsChoiceItem = new models.MetadataRibbonItem("editorsChoice");
        editorsChoiceItem.moduleType = "editorialBadgeInfo";
        // Only use an ad override locale if this is an ad.
        editorsChoiceItem.useAdsLocale =
            (isSome((_a = lockup.searchAdOpportunity) === null || _a === void 0 ? void 0 : _a.searchAd) || isSome(lockup.searchAd)) &&
                isSome(objectGraph.bag.adsOverrideLanguage);
        const impressionOptions = metricsHelpersImpressions.impressionOptionsForMetadataRibbonItem(metricsOptions, "editorialBadgeInfo", "Editors Choice", "static");
        metricsHelpersImpressions.addImpressionFieldsToSearchMetadataRibbonItem(objectGraph, editorsChoiceItem, impressionOptions);
        return [editorsChoiceItem];
    }
    else {
        return null;
    }
}
//# sourceMappingURL=editors-choice-metadata-ribbon-item.js.map