import { isSome } from "@jet/environment";
import { MetadataRibbonItem } from "../../../api/models";
import { isNullOrEmpty } from "../../../foundation/json-parsing/server-data";
import { categoryArtworkData } from "../../categories";
import * as content from "../../content/content";
import { categoryFromData } from "../../lockups/lockups";
import * as metricsHelpersImpressions from "../../metrics/helpers/impressions";
export function createMetadataRibbonItems(objectGraph, data, lockup, dedupeSet, metricsOptions) {
    const artworkData = categoryArtworkData(objectGraph, data, true);
    const hasArtwork = isSome(artworkData);
    const labelText = categoryFromData(objectGraph, data);
    if (isNullOrEmpty(labelText)) {
        return null;
    }
    if (labelText != null) {
        if (dedupeSet.has(labelText)) {
            return null;
        }
        else {
            dedupeSet.add(labelText);
        }
    }
    const viewType = hasArtwork ? "imageWithLabel" : "textLabel";
    const categoryItem = new MetadataRibbonItem(viewType);
    categoryItem.moduleType = "genreDisplayName";
    categoryItem.labelText = labelText;
    if (hasArtwork) {
        const artwork = content.artworkFromApiArtwork(objectGraph, artworkData, {
            useCase: 20 /* content.ArtworkUseCase.CategoryIcon */,
        });
        artwork.crop = "sr";
        categoryItem.artwork = artwork;
    }
    const impressionOptions = metricsHelpersImpressions.impressionOptionsForMetadataRibbonItem(metricsOptions, "genreDisplayName", categoryItem.labelText, "static");
    metricsHelpersImpressions.addImpressionFieldsToSearchMetadataRibbonItem(objectGraph, categoryItem, impressionOptions);
    return [categoryItem];
}
//# sourceMappingURL=category-metadata-ribbon-item.js.map