import * as models from "../../../api/models";
import * as mediaAttributes from "../../../foundation/media/attributes";
import { asInterface } from "../../../foundation/json-parsing/server-data";
import { createMetricsOptionsForGenericSearchPageShelf } from "../../metrics/helpers/search/search-shelves";
import { isNothing } from "@jet/environment";
// The types of search pages shelves can render in
export var SearchPageType;
(function (SearchPageType) {
    SearchPageType[SearchPageType["Landing"] = 0] = "Landing";
    SearchPageType[SearchPageType["Results"] = 1] = "Results";
    SearchPageType[SearchPageType["ChartsAndCategories"] = 2] = "ChartsAndCategories";
    SearchPageType[SearchPageType["Focus"] = 3] = "Focus";
})(SearchPageType || (SearchPageType = {}));
/**
 * Collections the shelf's attributes
 * @param objectGraph The App Store Object Graph
 * @param data The shelf data object
 * @returns The attributes for the shelf
 */
export function shelfAttributesFromData(objectGraph, data, shelfKind = undefined, pageKind = models.SearchPageKind.Default) {
    var _a, _b, _c;
    const title = (_a = mediaAttributes.attributeAsString(data, "title")) !== null && _a !== void 0 ? _a : undefined;
    let displayStyle = (_b = mediaAttributes.attributeAsInterface(data, "displayStyle")) !== null && _b !== void 0 ? _b : undefined;
    /// If we are on the see-all page, we currently don't get back a displayStyle object, so we need to manually provide one
    /// for the tile brick type as see-all is hard-coded for that density everywhere else (natively)
    if (isNothing(displayStyle) && pageKind === models.SearchPageKind.CategoriesAndCharts) {
        displayStyle = {
            layoutDensity: models.GenericSearchPageShelfDisplayStyleDensity.Density1,
            layout: undefined,
            layoutSize: undefined,
        };
    }
    const itemDisplayStyleAttributes = mediaAttributes.attributeAsDictionary(data, "itemDisplayStyle");
    const itemDisplayStyle = asInterface(itemDisplayStyleAttributes);
    const hasSeeAll = mediaAttributes.attributeAsBooleanOrFalse(data, "hasSeeAll");
    const displayCount = (_c = mediaAttributes.attributeAsNumber(data, "displayCount")) !== null && _c !== void 0 ? _c : undefined;
    const seeAllURL = hasSeeAll ? data.href : undefined;
    return new models.SearchShelfAttributes(data.id, title, displayStyle, displayCount, hasSeeAll, seeAllURL, itemDisplayStyle, shelfKind);
}
/**
 * Creates a base shelf context for the search shelf
 * @param objectGraph The App Store Object Graph
 * @param data The shelf data object
 * @param shelfAttributes The shelf's attributes
 * @param searchPageContext The context for the page containing the shelf
 * @returns A standard shelf context for the shelf
 */
export function baseShelfContext(objectGraph, data, shelfAttributes, searchPageContext) {
    return {
        metricsOptions: createMetricsOptionsForGenericSearchPageShelf(objectGraph, data, shelfAttributes, searchPageContext),
    };
}
//# sourceMappingURL=search-shelves.js.map