/**
 * Common functions for search results content.
 */
import { isDefinedNonNullNonEmpty } from "../../../foundation/json-parsing/server-data";
import { attributeAsBooleanOrFalse, attributeAsString } from "../../../foundation/media/attributes";
// region Editorial Content
/**
 * Returns the headline / tagline for Editorial Search Results
 * @param resultData Data to determine tagline for.
 */
export function editorialSearchResultTagline(objectGraph, resultData) {
    // Flag to disable showing specific headings, e.g. "App of the Day" that may be unnatural in search result
    const showLabelInSearch = attributeAsBooleanOrFalse(resultData, "showLabelInSearch");
    if (!showLabelInSearch) {
        return null;
    }
    // <rdar://problem/40468686> LOC: AOTD & GOTD badges in Search result for the Editorial Item Card AOTD & GOTD stories do not show up correctly for JA-JP and TH-TH
    // Always use alternative label, if one is provided.
    const alternateLabel = attributeAsString(resultData, "alternateLabel");
    if (isDefinedNonNullNonEmpty(alternateLabel)) {
        return alternateLabel; // No newline flattening needed for alternativeLabel
    }
    // Otherwise, fallback to franchise label, if any.
    const label = attributeAsString(resultData, "label");
    if (isDefinedNonNullNonEmpty(label)) {
        return label.replace(/\n/g, " ");
    }
    return null;
}
// endregion
//# sourceMappingURL=search-content-common.js.map